/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInputBuilder;

public class PortModInputMessageFactory
implements OFDeserializer<PortModInput> {
    private static final byte PADDING_IN_PORT_MOD_MESSAGE_1 = 4;
    private static final byte PADDING_IN_PORT_MOD_MESSAGE_2 = 2;
    private static final byte PADDING_IN_PORT_MOD_MESSAGE_3 = 4;

    public PortModInput deserialize(ByteBuf rawMessage) {
        PortModInputBuilder builder = new PortModInputBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setPortNo(new PortNumber(Long.valueOf(rawMessage.readUnsignedInt())));
        rawMessage.skipBytes(4);
        byte[] hwAddress = new byte[6];
        rawMessage.readBytes(hwAddress);
        builder.setHwAddress(new MacAddress(ByteBufUtils.macAddressToString((byte[])hwAddress)));
        rawMessage.skipBytes(2);
        builder.setConfig(PortModInputMessageFactory.createPortConfig(rawMessage.readUnsignedInt()));
        builder.setMask(PortModInputMessageFactory.createPortConfig(rawMessage.readUnsignedInt()));
        builder.setAdvertise(PortModInputMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        rawMessage.skipBytes(4);
        return builder.build();
    }

    private static PortConfig createPortConfig(long input) {
        Boolean pcPortDown = (input & 1L) != 0L;
        Boolean pcNRecv = (input & 4L) != 0L;
        Boolean pcNFwd = (input & 0x20L) != 0L;
        Boolean pcNPacketIn = (input & 0x40L) != 0L;
        return new PortConfig(pcNFwd, pcNPacketIn, pcNRecv, pcPortDown);
    }

    private static PortFeatures createPortFeatures(long input) {
        Boolean pf10mbHd = (input & 1L) != 0L;
        Boolean pf10mbFd = (input & 2L) != 0L;
        Boolean pf100mbHd = (input & 4L) != 0L;
        Boolean pf100mbFd = (input & 8L) != 0L;
        Boolean pf1gbHd = (input & 0x10L) != 0L;
        Boolean pf1gbFd = (input & 0x20L) != 0L;
        Boolean pf10gbFd = (input & 0x40L) != 0L;
        Boolean pf40gbFd = (input & 0x80L) != 0L;
        Boolean pf100gbFd = (input & 0x100L) != 0L;
        Boolean pf1tbFd = (input & 0x200L) != 0L;
        Boolean pfOther = (input & 0x400L) != 0L;
        Boolean pfCopper = (input & 0x800L) != 0L;
        Boolean pfFiber = (input & 0x1000L) != 0L;
        Boolean pfAutoneg = (input & 0x2000L) != 0L;
        Boolean pfPause = (input & 0x4000L) != 0L;
        Boolean pfPauseAsym = (input & 0x8000L) != 0L;
        return new PortFeatures(pf100gbFd, pf100mbFd, pf100mbHd, pf10gbFd, pf10mbFd, pf10mbHd, pf1gbFd, pf1gbHd, pf1tbFd, pf40gbFd, pfAutoneg, pfCopper, pfFiber, pfOther, pfPause, pfPauseAsym);
    }
}

