/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessageBuilder;

public class PortStatusMessageFactory
implements OFDeserializer<PortStatusMessage> {
    private static final byte PADDING_IN_PORT_STATUS_HEADER = 7;
    private static final byte PADDING_IN_OFP_PORT_HEADER_1 = 4;
    private static final byte PADDING_IN_OFP_PORT_HEADER_2 = 2;

    public PortStatusMessage deserialize(ByteBuf rawMessage) {
        PortStatusMessageBuilder builder = new PortStatusMessageBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setReason(PortReason.forValue((int)rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(7);
        builder.setPortNo(Long.valueOf(rawMessage.readUnsignedInt()));
        rawMessage.skipBytes(4);
        byte[] hwAddress = new byte[6];
        rawMessage.readBytes(hwAddress);
        builder.setHwAddr(new MacAddress(ByteBufUtils.macAddressToString((byte[])hwAddress)));
        rawMessage.skipBytes(2);
        builder.setName(ByteBufUtils.decodeNullTerminatedString((ByteBuf)rawMessage, (int)16));
        builder.setConfig(PortStatusMessageFactory.createPortConfig(rawMessage.readUnsignedInt()));
        builder.setState(PortStatusMessageFactory.createPortState(rawMessage.readUnsignedInt()));
        builder.setCurrentFeatures(PortStatusMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setAdvertisedFeatures(PortStatusMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setSupportedFeatures(PortStatusMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setPeerFeatures(PortStatusMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setCurrSpeed(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setMaxSpeed(Long.valueOf(rawMessage.readUnsignedInt()));
        return builder.build();
    }

    private static PortFeatures createPortFeatures(long input) {
        Boolean pf10mbHd = (input & 1L) != 0L;
        Boolean pf10mbFd = (input & 2L) != 0L;
        Boolean pf100mbHd = (input & 4L) != 0L;
        Boolean pf100mbFd = (input & 8L) != 0L;
        Boolean pf1gbHd = (input & 0x10L) != 0L;
        Boolean pf1gbFd = (input & 0x20L) != 0L;
        Boolean pf10gbFd = (input & 0x40L) != 0L;
        Boolean pf40gbFd = (input & 0x80L) != 0L;
        Boolean pf100gbFd = (input & 0x100L) != 0L;
        Boolean pf1tbFd = (input & 0x200L) != 0L;
        Boolean pfOther = (input & 0x400L) != 0L;
        Boolean pfCopper = (input & 0x800L) != 0L;
        Boolean pfFiber = (input & 0x1000L) != 0L;
        Boolean pfAutoneg = (input & 0x2000L) != 0L;
        Boolean pfPause = (input & 0x4000L) != 0L;
        Boolean pfPauseAsym = (input & 0x8000L) != 0L;
        return new PortFeatures(pf100gbFd, pf100mbFd, pf100mbHd, pf10gbFd, pf10mbFd, pf10mbHd, pf1gbFd, pf1gbHd, pf1tbFd, pf40gbFd, pfAutoneg, pfCopper, pfFiber, pfOther, pfPause, pfPauseAsym);
    }

    private static PortState createPortState(long input) {
        Boolean psLinkDown = (input & 1L) != 0L;
        Boolean psBblocked = (input & 2L) != 0L;
        Boolean psLive = (input & 4L) != 0L;
        return new PortState(psBblocked, psLinkDown, psLive);
    }

    private static PortConfig createPortConfig(long input) {
        Boolean pcPortDown = (input & 1L) != 0L;
        Boolean pcNoRecv = (input & 4L) != 0L;
        Boolean pcNoFwd = (input & 0x20L) != 0L;
        Boolean pcNoPacketIn = (input & 0x40L) != 0L;
        return new PortConfig(pcNoFwd, pcNoPacketIn, pcNoRecv, pcPortDown);
    }
}

