/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ControllerRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestOutputBuilder;

public class RoleReplyMessageFactory
implements OFDeserializer<RoleRequestOutput> {
    private static final byte PADDING_IN_ROLE_REPLY_HEADER = 4;

    public RoleRequestOutput deserialize(ByteBuf rawMessage) {
        RoleRequestOutputBuilder builder = new RoleRequestOutputBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setRole(ControllerRole.forValue((int)((int)rawMessage.readUnsignedInt())));
        rawMessage.skipBytes(4);
        byte[] generationID = new byte[8];
        rawMessage.readBytes(generationID);
        builder.setGenerationId(new BigInteger(1, generationID));
        return builder.build();
    }
}

