/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ControllerRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestInputBuilder;

public class RoleRequestInputMessageFactory
implements OFDeserializer<RoleRequestInput> {
    private static final byte PADDING = 4;

    public RoleRequestInput deserialize(ByteBuf rawMessage) {
        RoleRequestInputBuilder builder = new RoleRequestInputBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setRole(ControllerRole.forValue((int)rawMessage.readInt()));
        rawMessage.skipBytes(4);
        byte[] generationId = new byte[8];
        rawMessage.readBytes(generationId);
        builder.setGenerationId(new BigInteger(1, generationId));
        return builder.build();
    }
}

