/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableModInputBuilder;

public class TableModInputMessageFactory
implements OFDeserializer<TableModInput> {
    private static final byte PADDING_IN_TABLE_MOD_MESSAGE = 3;

    public TableModInput deserialize(ByteBuf rawMessage) {
        TableModInputBuilder builder = new TableModInputBuilder();
        builder.setVersion(Short.valueOf((short)4));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setTableId(new TableId(Long.valueOf(rawMessage.readUnsignedByte())));
        rawMessage.skipBytes(3);
        builder.setConfig(TableModInputMessageFactory.createTableConfig(rawMessage.readUnsignedInt()));
        return builder.build();
    }

    private static TableConfig createTableConfig(long input) {
        boolean deprecated = (input & 3L) != 0L;
        return new TableConfig(Boolean.valueOf(deprecated));
    }
}

