/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.util.ExperimenterDeserializerKeyFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.experimenter.core.ExperimenterDataOfChoice;

public class VendorMessageFactory
implements OFDeserializer<ExperimenterMessage>,
DeserializerRegistryInjector {
    private DeserializerRegistry deserializerRegistry;

    public ExperimenterMessage deserialize(ByteBuf message) {
        long xid = message.readUnsignedInt();
        long expId = message.readUnsignedInt();
        OFDeserializer deserializer = (OFDeserializer)this.deserializerRegistry.getDeserializer((MessageCodeKey)ExperimenterDeserializerKeyFactory.createVendorMessageDeserializerKey((short)1, (long)expId));
        ExperimenterDataOfChoice vendorData = (ExperimenterDataOfChoice)deserializer.deserialize(message);
        ExperimenterMessageBuilder messageBld = new ExperimenterMessageBuilder().setVersion(Short.valueOf((short)1)).setXid(Long.valueOf(xid)).setExperimenter(new ExperimenterId(Long.valueOf(expId))).setExperimenterDataOfChoice(vendorData);
        return messageBld.build();
    }

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.deserializerRegistry = deserializerRegistry;
    }
}

