/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.instruction;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.CodeKeyMakerFactory;
import org.opendaylight.openflowjava.protocol.impl.util.ListDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;

public abstract class AbstractActionInstructionDeserializer
implements OFDeserializer<Instruction>,
DeserializerRegistryInjector {
    private DeserializerRegistry registry;

    protected List<Action> deserializeActions(ByteBuf input, int instructionLength) {
        int length = instructionLength - 8;
        CodeKeyMaker keyMaker = CodeKeyMakerFactory.createActionsKeyMaker((short)4);
        List<Action> actions = ListDeserializer.deserializeList((short)4, length, input, keyMaker, this.getRegistry());
        return actions;
    }

    protected DeserializerRegistry getRegistry() {
        return this.registry;
    }

    public void injectDeserializerRegistry(DeserializerRegistry deserializerRegistry) {
        this.registry = deserializerRegistry;
    }
}

