/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.HeaderDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;

public abstract class AbstractOxmMatchEntryDeserializer
implements HeaderDeserializer<MatchEntry> {
    public MatchEntry deserializeHeader(ByteBuf input) {
        MatchEntryBuilder builder = this.processHeader(this.getOxmClass(), this.getOxmField(), input);
        return builder.build();
    }

    protected abstract Class<? extends MatchField> getOxmField();

    protected abstract Class<? extends OxmClassBase> getOxmClass();

    protected MatchEntryBuilder processHeader(Class<? extends OxmClassBase> oxmClass, Class<? extends MatchField> oxmField, ByteBuf input) {
        MatchEntryBuilder builder = new MatchEntryBuilder();
        builder.setOxmClass(oxmClass);
        input.skipBytes(2);
        builder.setOxmMatchField(oxmField);
        boolean hasMask = (input.readUnsignedByte() & 1) != 0;
        builder.setHasMask(Boolean.valueOf(hasMask));
        input.skipBytes(1);
        return builder;
    }
}

