/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.AbstractOxmMatchEntryDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.OxmDeserializerHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ArpSha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpShaCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.arp.sha._case.ArpShaBuilder;

public class OxmArpShaDeserializer
extends AbstractOxmMatchEntryDeserializer
implements OFDeserializer<MatchEntry> {
    public MatchEntry deserialize(ByteBuf input) {
        MatchEntryBuilder builder = this.processHeader(this.getOxmClass(), this.getOxmField(), input);
        OxmArpShaDeserializer.addArpShaValue(input, builder);
        return builder.build();
    }

    private static void addArpShaValue(ByteBuf input, MatchEntryBuilder builder) {
        ArpShaCaseBuilder caseBuilder = new ArpShaCaseBuilder();
        ArpShaBuilder shaBuilder = new ArpShaBuilder();
        shaBuilder.setMacAddress(OxmDeserializerHelper.convertMacAddress(input));
        if (builder.isHasMask().booleanValue()) {
            shaBuilder.setMask(OxmDeserializerHelper.convertMask(input, 6));
        }
        caseBuilder.setArpSha(shaBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
    }

    @Override
    protected Class<? extends MatchField> getOxmField() {
        return ArpSha.class;
    }

    @Override
    protected Class<? extends OxmClassBase> getOxmClass() {
        return OpenflowBasicClass.class;
    }
}

