/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.AbstractOxmMatchEntryDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.OxmDeserializerHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.EthSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.EthSrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.eth.src._case.EthSrcBuilder;

public class OxmEthSrcDeserializer
extends AbstractOxmMatchEntryDeserializer
implements OFDeserializer<MatchEntry> {
    public MatchEntry deserialize(ByteBuf input) {
        MatchEntryBuilder builder = this.processHeader(this.getOxmClass(), this.getOxmField(), input);
        OxmEthSrcDeserializer.addEthSrcValue(input, builder);
        return builder.build();
    }

    private static void addEthSrcValue(ByteBuf input, MatchEntryBuilder builder) {
        EthSrcCaseBuilder caseBuilder = new EthSrcCaseBuilder();
        EthSrcBuilder ethBuilder = new EthSrcBuilder();
        ethBuilder.setMacAddress(OxmDeserializerHelper.convertMacAddress(input));
        if (builder.isHasMask().booleanValue()) {
            ethBuilder.setMask(OxmDeserializerHelper.convertMask(input, 6));
        }
        caseBuilder.setEthSrc(ethBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
    }

    @Override
    protected Class<? extends MatchField> getOxmField() {
        return EthSrc.class;
    }

    @Override
    protected Class<? extends OxmClassBase> getOxmClass() {
        return OpenflowBasicClass.class;
    }
}

