/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.AbstractOxmMatchEntryDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.EthType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.EthTypeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.eth.type._case.EthTypeBuilder;

public class OxmEthTypeDeserializer
extends AbstractOxmMatchEntryDeserializer
implements OFDeserializer<MatchEntry> {
    public MatchEntry deserialize(ByteBuf input) {
        MatchEntryBuilder builder = this.processHeader(this.getOxmClass(), this.getOxmField(), input);
        OxmEthTypeDeserializer.addEthTypeValue(input, builder);
        return builder.build();
    }

    private static void addEthTypeValue(ByteBuf input, MatchEntryBuilder builder) {
        EthTypeCaseBuilder caseBuilder = new EthTypeCaseBuilder();
        EthTypeBuilder ethBuilder = new EthTypeBuilder();
        ethBuilder.setEthType(new EtherType(Integer.valueOf(input.readUnsignedShort())));
        caseBuilder.setEthType(ethBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
    }

    @Override
    protected Class<? extends MatchField> getOxmField() {
        return EthType.class;
    }

    @Override
    protected Class<? extends OxmClassBase> getOxmClass() {
        return OpenflowBasicClass.class;
    }
}

