/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.AbstractOxmMatchEntryDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Icmpv4Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Icmpv4CodeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv4.code._case.Icmpv4CodeBuilder;

public class OxmIcmpv4CodeDeserializer
extends AbstractOxmMatchEntryDeserializer
implements OFDeserializer<MatchEntry> {
    public MatchEntry deserialize(ByteBuf input) {
        MatchEntryBuilder builder = this.processHeader(this.getOxmClass(), this.getOxmField(), input);
        OxmIcmpv4CodeDeserializer.addIcmpv4CodeValue(input, builder);
        return builder.build();
    }

    private static void addIcmpv4CodeValue(ByteBuf input, MatchEntryBuilder builder) {
        Icmpv4CodeCaseBuilder caseBuilder = new Icmpv4CodeCaseBuilder();
        Icmpv4CodeBuilder icmpBuilder = new Icmpv4CodeBuilder();
        icmpBuilder.setIcmpv4Code(Short.valueOf(input.readUnsignedByte()));
        caseBuilder.setIcmpv4Code(icmpBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
    }

    @Override
    protected Class<? extends MatchField> getOxmField() {
        return Icmpv4Code.class;
    }

    @Override
    protected Class<? extends OxmClassBase> getOxmClass() {
        return OpenflowBasicClass.class;
    }
}

