/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.AbstractOxmMatchEntryDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.OxmDeserializerHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Ipv6ExthdrFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Exthdr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6ExthdrCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.exthdr._case.Ipv6ExthdrBuilder;

public class OxmIpv6ExtHdrDeserializer
extends AbstractOxmMatchEntryDeserializer
implements OFDeserializer<MatchEntry> {
    public MatchEntry deserialize(ByteBuf input) {
        MatchEntryBuilder builder = this.processHeader(this.getOxmClass(), this.getOxmField(), input);
        OxmIpv6ExtHdrDeserializer.addIpv6ExtHdrValue(input, builder);
        return builder.build();
    }

    private static void addIpv6ExtHdrValue(ByteBuf input, MatchEntryBuilder builder) {
        Ipv6ExthdrCaseBuilder caseBuilder = new Ipv6ExthdrCaseBuilder();
        Ipv6ExthdrBuilder extHdrBuilder = new Ipv6ExthdrBuilder();
        extHdrBuilder.setPseudoField(OxmIpv6ExtHdrDeserializer.convertPseudofields(input));
        if (builder.isHasMask().booleanValue()) {
            extHdrBuilder.setMask(OxmDeserializerHelper.convertMask(input, 2));
        }
        caseBuilder.setIpv6Exthdr(extHdrBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
    }

    private static Ipv6ExthdrFlags convertPseudofields(ByteBuf input) {
        int bitmap = input.readUnsignedShort();
        Boolean nonext = (bitmap & 1) != 0;
        Boolean esp = (bitmap & 2) != 0;
        Boolean auth = (bitmap & 4) != 0;
        Boolean dest = (bitmap & 8) != 0;
        Boolean frag = (bitmap & 0x10) != 0;
        Boolean router = (bitmap & 0x20) != 0;
        Boolean hop = (bitmap & 0x40) != 0;
        Boolean unrep = (bitmap & 0x80) != 0;
        Boolean unseq = (bitmap & 0x100) != 0;
        return new Ipv6ExthdrFlags(auth, dest, esp, frag, hop, nonext, router, unrep, unseq);
    }

    @Override
    protected Class<? extends MatchField> getOxmField() {
        return Ipv6Exthdr.class;
    }

    @Override
    protected Class<? extends OxmClassBase> getOxmClass() {
        return OpenflowBasicClass.class;
    }
}

