/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.AbstractOxmMatchEntryDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.OxmDeserializerHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6NdTll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6NdTllCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.nd.tll._case.Ipv6NdTllBuilder;

public class OxmIpv6NdTllDeserializer
extends AbstractOxmMatchEntryDeserializer
implements OFDeserializer<MatchEntry> {
    public MatchEntry deserialize(ByteBuf input) {
        MatchEntryBuilder builder = this.processHeader(this.getOxmClass(), this.getOxmField(), input);
        OxmIpv6NdTllDeserializer.addIpv6NdTllValue(input, builder);
        return builder.build();
    }

    private static void addIpv6NdTllValue(ByteBuf input, MatchEntryBuilder builder) {
        Ipv6NdTllCaseBuilder caseBuilder = new Ipv6NdTllCaseBuilder();
        Ipv6NdTllBuilder ndBuilder = new Ipv6NdTllBuilder();
        ndBuilder.setMacAddress(OxmDeserializerHelper.convertMacAddress(input));
        caseBuilder.setIpv6NdTll(ndBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
    }

    @Override
    protected Class<? extends MatchField> getOxmField() {
        return Ipv6NdTll.class;
    }

    @Override
    protected Class<? extends OxmClassBase> getOxmClass() {
        return OpenflowBasicClass.class;
    }
}

