/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization;

import org.opendaylight.openflowjava.protocol.api.extensibility.OFGeneralSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.impl.serialization.instruction.ApplyActionsInstructionSerializer;
import org.opendaylight.openflowjava.protocol.impl.serialization.instruction.ClearActionsInstructionSerializer;
import org.opendaylight.openflowjava.protocol.impl.serialization.instruction.GoToTableInstructionSerializer;
import org.opendaylight.openflowjava.protocol.impl.serialization.instruction.MeterInstructionSerializer;
import org.opendaylight.openflowjava.protocol.impl.serialization.instruction.WriteActionsInstructionSerializer;
import org.opendaylight.openflowjava.protocol.impl.serialization.instruction.WriteMetadataInstructionSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.InstructionSerializerRegistryHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ApplyActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ClearActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.GotoTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.MeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.WriteActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.WriteMetadataCase;

public final class InstructionsInitializer {
    private InstructionsInitializer() {
        throw new UnsupportedOperationException("Utility class shouldn't be instantiated");
    }

    public static void registerInstructionSerializers(SerializerRegistry serializerRegistry) {
        InstructionSerializerRegistryHelper helper = new InstructionSerializerRegistryHelper(4, serializerRegistry);
        helper.registerSerializer(GotoTableCase.class, (OFGeneralSerializer)new GoToTableInstructionSerializer());
        helper.registerSerializer(WriteMetadataCase.class, (OFGeneralSerializer)new WriteMetadataInstructionSerializer());
        helper.registerSerializer(WriteActionsCase.class, (OFGeneralSerializer)new WriteActionsInstructionSerializer());
        helper.registerSerializer(ApplyActionsCase.class, (OFGeneralSerializer)new ApplyActionsInstructionSerializer());
        helper.registerSerializer(ClearActionsCase.class, (OFGeneralSerializer)new ClearActionsInstructionSerializer());
        helper.registerSerializer(MeterCase.class, (OFGeneralSerializer)new MeterInstructionSerializer());
    }
}

