/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFGeneralSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.ActionsInitializer;
import org.opendaylight.openflowjava.protocol.impl.serialization.AdditionalMessageFactoryInitializer;
import org.opendaylight.openflowjava.protocol.impl.serialization.InstructionsInitializer;
import org.opendaylight.openflowjava.protocol.impl.serialization.MatchEntriesInitializer;
import org.opendaylight.openflowjava.protocol.impl.serialization.MessageFactoryInitializer;
import org.opendaylight.openflowjava.protocol.impl.util.OF10MatchSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.OF13MatchSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerRegistryImpl
implements SerializerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializerRegistryImpl.class);
    private static final short OF10 = 1;
    private static final short OF13 = 4;
    private Map<MessageTypeKey<?>, OFGeneralSerializer> registry;

    public void init() {
        this.registry = new HashMap();
        MessageFactoryInitializer.registerMessageSerializers(this);
        AdditionalMessageFactoryInitializer.registerMessageSerializers(this);
        this.registerSerializer(new MessageTypeKey(1, MatchV10.class), (OFGeneralSerializer)new OF10MatchSerializer());
        this.registerSerializer(new MessageTypeKey(4, Match.class), (OFGeneralSerializer)new OF13MatchSerializer());
        MatchEntriesInitializer.registerMatchEntrySerializers(this);
        ActionsInitializer.registerActionSerializers(this);
        InstructionsInitializer.registerInstructionSerializers(this);
    }

    public <K, S extends OFGeneralSerializer> S getSerializer(MessageTypeKey<K> msgTypeKey) {
        OFGeneralSerializer serializer = this.registry.get(msgTypeKey);
        if (serializer == null) {
            throw new IllegalStateException("Serializer for key: " + msgTypeKey + " was not found - please verify that you are using correct message" + " combination (e.g. OF v1.0 message to OF v1.0 device)");
        }
        return (S)serializer;
    }

    public <K> void registerSerializer(MessageTypeKey<K> msgTypeKey, OFGeneralSerializer serializer) {
        if (msgTypeKey == null || serializer == null) {
            throw new IllegalArgumentException("MessageTypeKey or Serializer is null");
        }
        OFGeneralSerializer serInRegistry = this.registry.put(msgTypeKey, serializer);
        if (serInRegistry != null) {
            LOGGER.debug("Serializer for key {} overwritten. Old serializer: {}, new serializer: {}", new Object[]{msgTypeKey, serInRegistry.getClass().getName(), serializer.getClass().getName()});
        }
        if (serializer instanceof SerializerRegistryInjector) {
            ((SerializerRegistryInjector)serializer).injectSerializerRegistry((SerializerRegistry)this);
        }
    }

    public <K> boolean unregisterSerializer(MessageTypeKey<K> msgTypeKey) {
        if (msgTypeKey == null) {
            throw new IllegalArgumentException("MessageTypeKey is null");
        }
        OFGeneralSerializer serializer = this.registry.remove(msgTypeKey);
        return serializer != null;
    }
}

