/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.action;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.HeaderSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.oxm.container.match.entry.value.ExperimenterIdCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetFieldCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ExperimenterClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF13SetFieldActionSerializer
implements OFSerializer<Action>,
HeaderSerializer<Action>,
SerializerRegistryInjector {
    private SerializerRegistry registry;

    public void serialize(Action action, ByteBuf outBuffer) {
        int startIndex = outBuffer.writerIndex();
        outBuffer.writeShort(25);
        int lengthIndex = outBuffer.writerIndex();
        outBuffer.writeShort(0);
        MatchEntry entry = (MatchEntry)((SetFieldCase)action.getActionChoice()).getSetFieldAction().getMatchEntry().get(0);
        MatchEntrySerializerKey key = new MatchEntrySerializerKey(4, entry.getOxmClass(), entry.getOxmMatchField());
        if (entry.getOxmClass().equals(ExperimenterClass.class)) {
            ExperimenterIdCase experimenterIdCase = (ExperimenterIdCase)entry.getMatchEntryValue();
            key.setExperimenterId(experimenterIdCase.getExperimenter().getExperimenter().getValue());
        } else {
            key.setExperimenterId(null);
        }
        OFSerializer serializer = (OFSerializer)this.registry.getSerializer((MessageTypeKey)key);
        serializer.serialize((DataContainer)entry, outBuffer);
        int paddingRemainder = (outBuffer.writerIndex() - startIndex) % 8;
        if (paddingRemainder != 0) {
            outBuffer.writeZero(8 - paddingRemainder);
        }
        outBuffer.setShort(lengthIndex, outBuffer.writerIndex() - startIndex);
    }

    public void serializeHeader(Action input, ByteBuf outBuffer) {
        outBuffer.writeShort(25);
        outBuffer.writeShort(4);
    }

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }
}

