/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.util.ListSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMakerFactory;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class FlowModInputMessageFactory
implements OFSerializer<FlowModInput>,
SerializerRegistryInjector {
    private static final byte MESSAGE_TYPE = 14;
    private static final byte PADDING_IN_FLOW_MOD_MESSAGE = 2;
    private static final TypeKeyMaker<Instruction> INSTRUCTION_KEY_MAKER = TypeKeyMakerFactory.createInstructionKeyMaker((short)4);
    private SerializerRegistry registry;

    public void serialize(FlowModInput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)14, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeLong(message.getCookie().longValue());
        outBuffer.writeLong(message.getCookieMask().longValue());
        outBuffer.writeByte((int)message.getTableId().getValue().byteValue());
        outBuffer.writeByte(message.getCommand().getIntValue());
        outBuffer.writeShort(message.getIdleTimeout().intValue());
        outBuffer.writeShort(message.getHardTimeout().intValue());
        outBuffer.writeShort(message.getPriority().intValue());
        outBuffer.writeInt(message.getBufferId().intValue());
        outBuffer.writeInt(message.getOutPort().getValue().intValue());
        outBuffer.writeInt(message.getOutGroup().intValue());
        outBuffer.writeShort(FlowModInputMessageFactory.createFlowModFlagsBitmask(message.getFlags()));
        outBuffer.writeZero(2);
        ((OFSerializer)this.registry.getSerializer(new MessageTypeKey(message.getVersion().shortValue(), Match.class))).serialize((DataContainer)message.getMatch(), outBuffer);
        ListSerializer.serializeList(message.getInstruction(), INSTRUCTION_KEY_MAKER, this.registry, outBuffer);
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }

    private static int createFlowModFlagsBitmask(FlowModFlags flags) {
        return ByteBufUtils.fillBitMask((int)0, (boolean[])new boolean[]{flags.isOFPFFSENDFLOWREM(), flags.isOFPFFCHECKOVERLAP(), flags.isOFPFFRESETCOUNTS(), flags.isOFPFFNOPKTCOUNTS(), flags.isOFPFFNOBYTCOUNTS()});
    }
}

