/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class FlowRemovedMessageFactory
implements OFSerializer<FlowRemovedMessage>,
SerializerRegistryInjector {
    private static final byte MESSAGE_TYPE = 11;
    private SerializerRegistry registry;

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }

    public void serialize(FlowRemovedMessage message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)11, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeLong(message.getCookie().longValue());
        outBuffer.writeShort(message.getPriority().intValue());
        outBuffer.writeByte(message.getReason().getIntValue());
        outBuffer.writeByte((int)message.getTableId().getValue().byteValue());
        outBuffer.writeInt(message.getDurationSec().intValue());
        outBuffer.writeInt(message.getDurationNsec().intValue());
        outBuffer.writeShort(message.getIdleTimeout().intValue());
        outBuffer.writeShort(message.getHardTimeout().intValue());
        outBuffer.writeLong(message.getPacketCount().longValue());
        outBuffer.writeLong(message.getByteCount().longValue());
        OFSerializer matchSerializer = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(message.getVersion().shortValue(), Match.class));
        matchSerializer.serialize((DataContainer)message.getMatch(), outBuffer);
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }
}

