/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Capabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;

public class GetFeaturesOutputFactory
implements OFSerializer<GetFeaturesOutput>,
SerializerRegistryInjector {
    private SerializerRegistry registry;
    private static final byte MESSAGE_TYPE = 6;
    private static final byte PADDING = 2;

    public void serialize(GetFeaturesOutput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)6, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeLong(message.getDatapathId().longValue());
        outBuffer.writeInt(message.getBuffers().intValue());
        outBuffer.writeByte(message.getTables().intValue());
        outBuffer.writeByte(message.getAuxiliaryId().intValue());
        outBuffer.writeZero(2);
        GetFeaturesOutputFactory.writeCapabilities(message.getCapabilities(), outBuffer);
        outBuffer.writeInt(message.getReserved().intValue());
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }

    private static void writeCapabilities(Capabilities capabilities, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, capabilities.isOFPCFLOWSTATS());
        map.put(1, capabilities.isOFPCTABLESTATS());
        map.put(2, capabilities.isOFPCPORTSTATS());
        map.put(3, capabilities.isOFPCGROUPSTATS());
        map.put(5, capabilities.isOFPCIPREASM());
        map.put(6, capabilities.isOFPCQUEUESTATS());
        map.put(8, capabilities.isOFPCPORTBLOCKED());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }
}

