/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.impl.util.ListSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMakerFactory;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsList;

public class GroupModInputMessageFactory
implements OFSerializer<GroupModInput>,
SerializerRegistryInjector {
    private static final byte MESSAGE_TYPE = 15;
    private static final byte PADDING_IN_GROUP_MOD_MESSAGE = 1;
    private static final byte PADDING_IN_BUCKET = 4;
    private SerializerRegistry registry;

    public void serialize(GroupModInput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)15, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeShort(message.getCommand().getIntValue());
        outBuffer.writeByte(message.getType().getIntValue());
        outBuffer.writeZero(1);
        outBuffer.writeInt(message.getGroupId().getValue().intValue());
        this.serializerBuckets(message.getBucketsList(), outBuffer);
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private void serializerBuckets(List<BucketsList> buckets, ByteBuf outBuffer) {
        if (buckets != null) {
            for (BucketsList currentBucket : buckets) {
                int bucketLengthIndex = outBuffer.writerIndex();
                outBuffer.writeShort(0);
                outBuffer.writeShort((int)currentBucket.getWeight().shortValue());
                outBuffer.writeInt(currentBucket.getWatchPort().getValue().intValue());
                outBuffer.writeInt(currentBucket.getWatchGroup().intValue());
                outBuffer.writeZero(4);
                ListSerializer.serializeList(currentBucket.getAction(), TypeKeyMakerFactory.createActionKeyMaker((short)4), this.registry, outBuffer);
                outBuffer.setShort(bucketLengthIndex, outBuffer.writerIndex() - bucketLengthIndex);
            }
        }
    }

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }
}

