/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.HelloElementType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello.Elements;

public class HelloInputMessageFactory
implements OFSerializer<HelloInput> {
    private static final byte MESSAGE_TYPE = 0;
    private static final byte HELLO_ELEMENT_HEADER_SIZE = 4;

    private static void serializeElementsList(HelloInput message, ByteBuf output) {
        if (message.getElements() != null) {
            for (Elements currElement : message.getElements()) {
                int elementStartIndex = output.writerIndex();
                output.writeShort(currElement.getType().getIntValue());
                if (!currElement.getType().equals((Object)HelloElementType.VERSIONBITMAP)) continue;
                int elementLengthIndex = output.writerIndex();
                output.writeShort(0);
                int[] versionBitmap = ByteBufUtils.fillBitMaskFromList((List)currElement.getVersionBitmap());
                for (int i = 0; i < versionBitmap.length; ++i) {
                    output.writeInt(versionBitmap[i]);
                }
                int length = output.writerIndex() - elementStartIndex;
                int padding = length - versionBitmap.length * 4 - 4;
                output.writeZero(padding);
                output.setShort(elementLengthIndex, output.writerIndex() - elementStartIndex);
            }
        }
    }

    public void serialize(HelloInput message, ByteBuf outBuffer) {
        int startWriterIndex = outBuffer.writerIndex();
        ByteBufUtils.writeOFHeader((byte)0, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        HelloInputMessageFactory.serializeElementsList(message, outBuffer);
        int endWriterIndex = outBuffer.writerIndex();
        int paddingRemainder = (endWriterIndex - startWriterIndex) % 8;
        if (paddingRemainder != 0) {
            outBuffer.writeZero(8 - paddingRemainder);
        }
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }
}

