/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.openflowjava.util.ExperimenterSerializerKeyFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ExperimenterIdMeterBand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterBandCommons;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.MeterBand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDropCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDscpRemarkCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.drop._case.MeterBandDrop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.dscp.remark._case.MeterBandDscpRemark;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.experimenter._case.MeterBandExperimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.mod.Bands;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class MeterModInputMessageFactory
implements OFSerializer<MeterModInput>,
SerializerRegistryInjector {
    private static final byte MESSAGE_TYPE = 29;
    private static final short LENGTH_OF_METER_BANDS = 16;
    private static final short PADDING_IN_METER_BAND_DROP = 4;
    private static final short PADDING_IN_METER_BAND_DSCP_REMARK = 3;
    private SerializerRegistry registry;

    public void serialize(MeterModInput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)29, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeShort(message.getCommand().getIntValue());
        outBuffer.writeShort(MeterModInputMessageFactory.createMeterFlagsBitmask(message.getFlags()));
        outBuffer.writeInt(message.getMeterId().getValue().intValue());
        this.serializeBands(message.getBands(), outBuffer);
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private static int createMeterFlagsBitmask(MeterFlags flags) {
        return ByteBufUtils.fillBitMask((int)0, (boolean[])new boolean[]{flags.isOFPMFKBPS(), flags.isOFPMFPKTPS(), flags.isOFPMFBURST(), flags.isOFPMFSTATS()});
    }

    private void serializeBands(List<Bands> bands, ByteBuf outBuffer) {
        if (bands != null) {
            for (Bands currentBand : bands) {
                MeterBand meterBand = currentBand.getMeterBand();
                if (meterBand instanceof MeterBandDropCase) {
                    MeterBandDropCase dropBandCase = (MeterBandDropCase)meterBand;
                    MeterBandDrop dropBand = dropBandCase.getMeterBandDrop();
                    MeterModInputMessageFactory.writeBandCommonFields((MeterBandCommons)dropBand, outBuffer);
                    outBuffer.writeZero(4);
                    continue;
                }
                if (meterBand instanceof MeterBandDscpRemarkCase) {
                    MeterBandDscpRemarkCase dscpRemarkBandCase = (MeterBandDscpRemarkCase)meterBand;
                    MeterBandDscpRemark dscpRemarkBand = dscpRemarkBandCase.getMeterBandDscpRemark();
                    MeterModInputMessageFactory.writeBandCommonFields((MeterBandCommons)dscpRemarkBand, outBuffer);
                    outBuffer.writeByte((int)dscpRemarkBand.getPrecLevel().shortValue());
                    outBuffer.writeZero(3);
                    continue;
                }
                if (!(meterBand instanceof MeterBandExperimenterCase)) continue;
                MeterBandExperimenterCase experimenterBandCase = (MeterBandExperimenterCase)meterBand;
                MeterBandExperimenter experimenterBand = experimenterBandCase.getMeterBandExperimenter();
                long expId = ((ExperimenterIdMeterBand)experimenterBand.getAugmentation(ExperimenterIdMeterBand.class)).getExperimenter().getValue();
                OFSerializer serializer = (OFSerializer)this.registry.getSerializer((MessageTypeKey)ExperimenterSerializerKeyFactory.createMeterBandSerializerKey((short)4, (long)expId));
                serializer.serialize((DataContainer)experimenterBandCase, outBuffer);
            }
        }
    }

    private static void writeBandCommonFields(MeterBandCommons meterBand, ByteBuf outBuffer) {
        outBuffer.writeShort(meterBand.getType().getIntValue());
        outBuffer.writeShort(16);
        outBuffer.writeInt(meterBand.getRate().intValue());
        outBuffer.writeInt(meterBand.getBurstSize().intValue());
    }

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }
}

