/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.HashMap;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.util.ListSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMakerFactory;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.openflowjava.util.ExperimenterSerializerKeyFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ActionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ExperimenterIdTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.InstructionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.NextTableRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.OxmRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.table.features.properties.container.table.feature.properties.NextTableIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ActionType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandTypeBitmap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterBandCommons;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.MeterBand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDropCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDscpRemarkCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.drop._case.MeterBandDrop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.dscp.remark._case.MeterBandDscpRemark;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.experimenter._case.MeterBandExperimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.MultipartReplyBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterConfigCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.aggregate._case.MultipartReplyAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.desc._case.MultipartReplyDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.experimenter._case.MultipartReplyExperimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.MultipartReplyFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.MultipartReplyGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.GroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats.BucketStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.MultipartReplyGroupDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.multipart.reply.group.desc.GroupDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.features._case.MultipartReplyGroupFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.MultipartReplyMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.MeterStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats.MeterBandStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.MultipartReplyMeterConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.MeterConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.meter.config.Bands;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.features._case.MultipartReplyMeterFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.MultipartReplyPortDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.multipart.reply.port.desc.Ports;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.MultipartReplyPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.MultipartReplyQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.MultipartReplyTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.MultipartReplyTableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.multipart.reply.table.features.TableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeatureProperties;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class MultipartReplyMessageFactory
implements OFSerializer<MultipartReplyMessage>,
SerializerRegistryInjector {
    private static final byte MESSAGE_TYPE = 19;
    private SerializerRegistry registry;
    private static final byte PADDING = 4;
    private static final byte PORT_DESC_PADDING_1 = 4;
    private static final byte PORT_DESC_PADDING_2 = 2;
    private static final int FLOW_STATS_LENGTH_INDEX = 0;
    private static final byte FLOW_STATS_PADDING_1 = 1;
    private static final byte FLOW_STATS_PADDING_2 = 6;
    private static final byte AGGREGATE_PADDING = 4;
    private static final byte TABLE_PADDING = 3;
    private static final byte PORT_STATS_PADDING = 4;
    private static final byte GROUP_STATS_PADDING_1 = 2;
    private static final byte GROUP_STATS_PADDING_2 = 4;
    private static final int GROUP_STATS_LENGTH_INDEX = 0;
    private static final int GROUP_DESC_LENGTH_INDEX = 0;
    private static final int BUCKET_LENGTH_INDEX = 0;
    private static final byte GROUP_DESC_PADDING = 1;
    private static final byte BUCKET_PADDING = 4;
    private static final int METER_LENGTH_INDEX = 4;
    private static final byte METER_PADDING = 6;
    private static final int METER_CONFIG_LENGTH_INDEX = 0;
    private static final short LENGTH_OF_METER_BANDS = 16;
    private static final byte METER_FEATURES_PADDING = 2;
    private static final int TABLE_FEATURES_LENGTH_INDEX = 0;
    private static final byte TABLE_FEATURES_PADDING = 5;
    private static final byte INSTRUCTIONS_CODE = 0;
    private static final byte INSTRUCTIONS_MISS_CODE = 1;
    private static final byte NEXT_TABLE_CODE = 2;
    private static final byte NEXT_TABLE_MISS_CODE = 3;
    private static final byte WRITE_ACTIONS_CODE = 4;
    private static final byte WRITE_ACTIONS_MISS_CODE = 5;
    private static final byte APPLY_ACTIONS_CODE = 6;
    private static final byte APPLY_ACTIONS_MISS_CODE = 7;
    private static final byte MATCH_CODE = 8;
    private static final byte WILDCARDS_CODE = 10;
    private static final byte WRITE_SETFIELD_CODE = 12;
    private static final byte WRITE_SETFIELD_MISS_CODE = 13;
    private static final byte APPLY_SETFIELD_CODE = 14;
    private static final byte APPLY_SETFIELD_MISS_CODE = 15;

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }

    public void serialize(MultipartReplyMessage message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)19, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeShort(message.getType().getIntValue());
        this.writeFlags(message.getFlags(), outBuffer);
        outBuffer.writeZero(4);
        switch (message.getType()) {
            case OFPMPDESC: {
                this.serializeDescBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPFLOW: {
                this.serializeFlowBody(message.getMultipartReplyBody(), outBuffer, message);
                break;
            }
            case OFPMPAGGREGATE: {
                this.serializeAggregateBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPTABLE: {
                this.serializeTableBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPPORTSTATS: {
                this.serializePortStatsBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPQUEUE: {
                this.serializeQueueBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPGROUP: {
                this.serializeGroupBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPGROUPDESC: {
                this.serializeGroupDescBody(message.getMultipartReplyBody(), outBuffer, message);
                break;
            }
            case OFPMPGROUPFEATURES: {
                this.serializeGroupFeaturesBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPMETER: {
                this.serializeMeterBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPMETERCONFIG: {
                this.serializeMeterConfigBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPMETERFEATURES: {
                this.serializeMeterFeaturesBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPTABLEFEATURES: {
                this.serializeTableFeaturesBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPPORTDESC: {
                this.serializePortDescBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPEXPERIMENTER: {
                this.serializeExperimenterBody(message.getMultipartReplyBody(), outBuffer);
            }
        }
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private void serializeExperimenterBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyExperimenterCase experimenterCase = (MultipartReplyExperimenterCase)body;
        MultipartReplyExperimenter experimenterBody = experimenterCase.getMultipartReplyExperimenter();
    }

    private void writeFlags(MultipartRequestFlags flags, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, flags.isOFPMPFREQMORE());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeShort(bitmap);
    }

    private void serializeTableFeaturesBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyTableFeaturesCase tableFeaturesCase = (MultipartReplyTableFeaturesCase)body;
        MultipartReplyTableFeatures tableFeatures = tableFeaturesCase.getMultipartReplyTableFeatures();
        for (TableFeatures tableFeature : tableFeatures.getTableFeatures()) {
            ByteBuf tableFeatureBuff = UnpooledByteBufAllocator.DEFAULT.buffer();
            tableFeatureBuff.writeShort(0);
            tableFeatureBuff.writeByte((int)tableFeature.getTableId().shortValue());
            tableFeatureBuff.writeZero(5);
            this.write32String(tableFeature.getName(), tableFeatureBuff);
            tableFeatureBuff.writeBytes(tableFeature.getMetadataMatch());
            tableFeatureBuff.writeZero(64 - tableFeature.getMetadataMatch().length);
            tableFeatureBuff.writeBytes(tableFeature.getMetadataWrite());
            tableFeatureBuff.writeZero(64 - tableFeature.getMetadataWrite().length);
            this.writeTableConfig(tableFeature.getConfig(), tableFeatureBuff);
            tableFeatureBuff.writeInt(tableFeature.getMaxEntries().intValue());
            for (TableFeatureProperties tableFeatureProp : tableFeature.getTableFeatureProperties()) {
                switch (tableFeatureProp.getType()) {
                    case OFPTFPTINSTRUCTIONS: {
                        this.writeInstructionRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)0);
                        break;
                    }
                    case OFPTFPTINSTRUCTIONSMISS: {
                        this.writeInstructionRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)1);
                        break;
                    }
                    case OFPTFPTNEXTTABLES: {
                        MultipartReplyMessageFactory.writeNextTableRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)2);
                        break;
                    }
                    case OFPTFPTNEXTTABLESMISS: {
                        MultipartReplyMessageFactory.writeNextTableRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)3);
                        break;
                    }
                    case OFPTFPTWRITEACTIONS: {
                        this.writeActionsRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)4);
                        break;
                    }
                    case OFPTFPTWRITEACTIONSMISS: {
                        this.writeActionsRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)5);
                        break;
                    }
                    case OFPTFPTAPPLYACTIONS: {
                        this.writeActionsRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)6);
                        break;
                    }
                    case OFPTFPTAPPLYACTIONSMISS: {
                        this.writeActionsRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)7);
                        break;
                    }
                    case OFPTFPTMATCH: {
                        this.writeOxmRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)8);
                        break;
                    }
                    case OFPTFPTWILDCARDS: {
                        this.writeOxmRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)10);
                        break;
                    }
                    case OFPTFPTWRITESETFIELD: {
                        this.writeOxmRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)12);
                        break;
                    }
                    case OFPTFPTWRITESETFIELDMISS: {
                        this.writeOxmRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)13);
                        break;
                    }
                    case OFPTFPTAPPLYSETFIELD: {
                        this.writeOxmRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)14);
                        break;
                    }
                    case OFPTFPTAPPLYSETFIELDMISS: {
                        this.writeOxmRelatedTableProperty(tableFeatureBuff, tableFeatureProp, (byte)15);
                        break;
                    }
                    case OFPTFPTEXPERIMENTER: {
                        this.writeExperimenterRelatedTableProperty(tableFeatureBuff, tableFeatureProp);
                        break;
                    }
                    case OFPTFPTEXPERIMENTERMISS: {
                        this.writeExperimenterRelatedTableProperty(tableFeatureBuff, tableFeatureProp);
                    }
                }
            }
            tableFeatureBuff.setShort(0, tableFeatureBuff.readableBytes());
            outBuffer.writeBytes(tableFeatureBuff);
        }
    }

    private void writeExperimenterRelatedTableProperty(ByteBuf output, TableFeatureProperties property) {
        long expId = ((ExperimenterIdTableFeatureProperty)property.getAugmentation(ExperimenterIdTableFeatureProperty.class)).getExperimenter().getValue();
        OFSerializer serializer = (OFSerializer)this.registry.getSerializer((MessageTypeKey)ExperimenterSerializerKeyFactory.createMultipartRequestTFSerializerKey((short)4, (long)expId));
        serializer.serialize((DataContainer)property, output);
    }

    private void writeOxmRelatedTableProperty(ByteBuf output, TableFeatureProperties property, byte code) {
        int startIndex = output.writerIndex();
        output.writeShort((int)code);
        int lengthIndex = output.writerIndex();
        output.writeShort(0);
        List entries = ((OxmRelatedTableFeatureProperty)property.getAugmentation(OxmRelatedTableFeatureProperty.class)).getMatchEntry();
        if (entries != null) {
            TypeKeyMaker<MatchEntry> keyMaker = TypeKeyMakerFactory.createMatchEntriesKeyMaker((short)4);
            ListSerializer.serializeHeaderList(entries, keyMaker, this.registry, output);
        }
        int length = output.writerIndex() - startIndex;
        output.setShort(lengthIndex, length);
        output.writeZero(MultipartReplyMessageFactory.paddingNeeded(length));
    }

    private void writeActionsRelatedTableProperty(ByteBuf output, TableFeatureProperties property, byte code) {
        int startIndex = output.writerIndex();
        output.writeShort((int)code);
        int lengthIndex = output.writerIndex();
        output.writeShort(0);
        List actions = ((ActionRelatedTableFeatureProperty)property.getAugmentation(ActionRelatedTableFeatureProperty.class)).getAction();
        if (actions != null) {
            TypeKeyMaker<Action> keyMaker = TypeKeyMakerFactory.createActionKeyMaker((short)4);
            ListSerializer.serializeHeaderList(actions, keyMaker, this.registry, output);
        }
        int length = output.writerIndex() - startIndex;
        output.setShort(lengthIndex, length);
        output.writeZero(MultipartReplyMessageFactory.paddingNeeded(length));
    }

    private static void writeNextTableRelatedTableProperty(ByteBuf output, TableFeatureProperties property, byte code) {
        int startIndex = output.writerIndex();
        output.writeShort((int)code);
        int lengthIndex = output.writerIndex();
        output.writeShort(0);
        List nextTableIds = ((NextTableRelatedTableFeatureProperty)property.getAugmentation(NextTableRelatedTableFeatureProperty.class)).getNextTableIds();
        if (nextTableIds != null) {
            for (NextTableIds next : nextTableIds) {
                output.writeByte((int)next.getTableId().shortValue());
            }
        }
        int length = output.writerIndex() - startIndex;
        output.setShort(lengthIndex, length);
        output.writeZero(MultipartReplyMessageFactory.paddingNeeded(length));
    }

    private void writeInstructionRelatedTableProperty(ByteBuf output, TableFeatureProperties property, byte code) {
        int startIndex = output.writerIndex();
        output.writeShort((int)code);
        int lengthIndex = output.writerIndex();
        output.writeShort(0);
        List instructions = ((InstructionRelatedTableFeatureProperty)property.getAugmentation(InstructionRelatedTableFeatureProperty.class)).getInstruction();
        if (instructions != null) {
            TypeKeyMaker<Instruction> keyMaker = TypeKeyMakerFactory.createInstructionKeyMaker((short)4);
            ListSerializer.serializeHeaderList(instructions, keyMaker, this.registry, output);
        }
        int length = output.writerIndex() - startIndex;
        output.setShort(lengthIndex, length);
        output.writeZero(MultipartReplyMessageFactory.paddingNeeded(length));
    }

    private static int paddingNeeded(int length) {
        int paddingRemainder = length % 8;
        int result = 0;
        if (paddingRemainder != 0) {
            result = 8 - paddingRemainder;
        }
        return result;
    }

    private void writeTableConfig(TableConfig tableConfig, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, tableConfig.isOFPTCDEPRECATEDMASK());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }

    private void serializeMeterFeaturesBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyMeterFeaturesCase meterFeaturesCase = (MultipartReplyMeterFeaturesCase)body;
        MultipartReplyMeterFeatures meterFeatures = meterFeaturesCase.getMultipartReplyMeterFeatures();
        outBuffer.writeInt(meterFeatures.getMaxMeter().intValue());
        this.writeBandTypes(meterFeatures.getBandTypes(), outBuffer);
        this.writeMeterFlags(meterFeatures.getCapabilities(), outBuffer);
        outBuffer.writeByte((int)meterFeatures.getMaxBands().shortValue());
        outBuffer.writeByte((int)meterFeatures.getMaxColor().shortValue());
        outBuffer.writeZero(2);
    }

    private void writeBandTypes(MeterBandTypeBitmap bandTypes, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, bandTypes.isOFPMBTDROP());
        map.put(1, bandTypes.isOFPMBTDSCPREMARK());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }

    private void serializeMeterConfigBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyMeterConfigCase meterConfigCase = (MultipartReplyMeterConfigCase)body;
        MultipartReplyMeterConfig meter = meterConfigCase.getMultipartReplyMeterConfig();
        for (MeterConfig meterConfig : meter.getMeterConfig()) {
            ByteBuf meterConfigBuff = UnpooledByteBufAllocator.DEFAULT.buffer();
            meterConfigBuff.writeShort(0);
            this.writeMeterFlags(meterConfig.getFlags(), meterConfigBuff);
            meterConfigBuff.writeInt(meterConfig.getMeterId().getValue().intValue());
            for (Bands currentBand : meterConfig.getBands()) {
                MeterBand meterBand = currentBand.getMeterBand();
                if (meterBand instanceof MeterBandDropCase) {
                    MeterBandDropCase dropBandCase = (MeterBandDropCase)meterBand;
                    MeterBandDrop dropBand = dropBandCase.getMeterBandDrop();
                    MultipartReplyMessageFactory.writeBandCommonFields((MeterBandCommons)dropBand, meterConfigBuff);
                    continue;
                }
                if (meterBand instanceof MeterBandDscpRemarkCase) {
                    MeterBandDscpRemarkCase dscpRemarkBandCase = (MeterBandDscpRemarkCase)meterBand;
                    MeterBandDscpRemark dscpRemarkBand = dscpRemarkBandCase.getMeterBandDscpRemark();
                    MultipartReplyMessageFactory.writeBandCommonFields((MeterBandCommons)dscpRemarkBand, meterConfigBuff);
                    continue;
                }
                if (!(meterBand instanceof MeterBandExperimenterCase)) continue;
                MeterBandExperimenterCase experimenterBandCase = (MeterBandExperimenterCase)meterBand;
                MeterBandExperimenter experimenterBand = experimenterBandCase.getMeterBandExperimenter();
                MultipartReplyMessageFactory.writeBandCommonFields((MeterBandCommons)experimenterBand, meterConfigBuff);
            }
            meterConfigBuff.setShort(0, meterConfigBuff.readableBytes());
            outBuffer.writeBytes(meterConfigBuff);
        }
    }

    private static void writeBandCommonFields(MeterBandCommons meterBand, ByteBuf outBuffer) {
        outBuffer.writeShort(meterBand.getType().getIntValue());
        outBuffer.writeShort(16);
        outBuffer.writeInt(meterBand.getRate().intValue());
        outBuffer.writeInt(meterBand.getBurstSize().intValue());
    }

    private void writeMeterFlags(MeterFlags flags, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, flags.isOFPMFKBPS());
        map.put(1, flags.isOFPMFPKTPS());
        map.put(2, flags.isOFPMFBURST());
        map.put(3, flags.isOFPMFSTATS());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeShort(bitmap);
    }

    private void serializeMeterBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyMeterCase meterCase = (MultipartReplyMeterCase)body;
        MultipartReplyMeter meter = meterCase.getMultipartReplyMeter();
        for (MeterStats meterStats : meter.getMeterStats()) {
            ByteBuf meterStatsBuff = UnpooledByteBufAllocator.DEFAULT.buffer();
            meterStatsBuff.writeInt(meterStats.getMeterId().getValue().intValue());
            meterStatsBuff.writeInt(0);
            meterStatsBuff.writeZero(6);
            meterStatsBuff.writeInt(meterStats.getFlowCount().intValue());
            meterStatsBuff.writeLong(meterStats.getPacketInCount().longValue());
            meterStatsBuff.writeLong(meterStats.getByteInCount().longValue());
            meterStatsBuff.writeInt(meterStats.getDurationSec().intValue());
            meterStatsBuff.writeInt(meterStats.getDurationNsec().intValue());
            for (MeterBandStats meterBandStats : meterStats.getMeterBandStats()) {
                meterStatsBuff.writeLong(meterBandStats.getPacketBandCount().longValue());
                meterStatsBuff.writeLong(meterBandStats.getByteBandCount().longValue());
            }
            meterStatsBuff.setInt(4, meterStatsBuff.readableBytes());
            outBuffer.writeBytes(meterStatsBuff);
        }
    }

    private void serializeGroupFeaturesBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyGroupFeaturesCase groupFeaturesCase = (MultipartReplyGroupFeaturesCase)body;
        MultipartReplyGroupFeatures groupFeatures = groupFeaturesCase.getMultipartReplyGroupFeatures();
        this.writeGroupTypes(groupFeatures.getTypes(), outBuffer);
        this.writeGroupCapabilities(groupFeatures.getCapabilities(), outBuffer);
        for (Long maxGroups : groupFeatures.getMaxGroups()) {
            outBuffer.writeInt(maxGroups.intValue());
        }
        for (ActionType action : groupFeatures.getActionsBitmap()) {
            this.writeActionType(action, outBuffer);
        }
    }

    private void writeActionType(ActionType action, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, action.isOFPATOUTPUT());
        map.put(1, action.isOFPATCOPYTTLOUT());
        map.put(2, action.isOFPATCOPYTTLIN());
        map.put(3, action.isOFPATSETMPLSTTL());
        map.put(4, action.isOFPATDECMPLSTTL());
        map.put(5, action.isOFPATPUSHVLAN());
        map.put(6, action.isOFPATPOPVLAN());
        map.put(7, action.isOFPATPUSHMPLS());
        map.put(8, action.isOFPATPOPMPLS());
        map.put(9, action.isOFPATSETQUEUE());
        map.put(10, action.isOFPATGROUP());
        map.put(11, action.isOFPATSETNWTTL());
        map.put(12, action.isOFPATDECNWTTL());
        map.put(13, action.isOFPATSETFIELD());
        map.put(14, action.isOFPATPUSHPBB());
        map.put(15, action.isOFPATPOPPBB());
        map.put(16, action.isOFPATEXPERIMENTER());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }

    private void writeGroupCapabilities(GroupCapabilities capabilities, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, capabilities.isOFPGFCSELECTWEIGHT());
        map.put(1, capabilities.isOFPGFCSELECTLIVENESS());
        map.put(2, capabilities.isOFPGFCCHAINING());
        map.put(3, capabilities.isOFPGFCCHAININGCHECKS());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }

    private void writeGroupTypes(GroupTypes types, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, types.isOFPGTALL());
        map.put(1, types.isOFPGTSELECT());
        map.put(2, types.isOFPGTINDIRECT());
        map.put(3, types.isOFPGTFF());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }

    private void serializeGroupDescBody(MultipartReplyBody body, ByteBuf outBuffer, MultipartReplyMessage message) {
        MultipartReplyGroupDescCase groupDescCase = (MultipartReplyGroupDescCase)body;
        MultipartReplyGroupDesc group = groupDescCase.getMultipartReplyGroupDesc();
        for (GroupDesc groupDesc : group.getGroupDesc()) {
            ByteBuf groupDescBuff = UnpooledByteBufAllocator.DEFAULT.buffer();
            groupDescBuff.writeShort(0);
            groupDescBuff.writeByte(groupDesc.getType().getIntValue());
            groupDescBuff.writeZero(1);
            groupDescBuff.writeInt(groupDesc.getGroupId().getValue().intValue());
            for (BucketsList bucket : groupDesc.getBucketsList()) {
                ByteBuf bucketBuff = UnpooledByteBufAllocator.DEFAULT.buffer();
                bucketBuff.writeShort(0);
                bucketBuff.writeShort(bucket.getWeight().intValue());
                bucketBuff.writeInt(bucket.getWatchPort().getValue().intValue());
                bucketBuff.writeInt(bucket.getWatchGroup().intValue());
                bucketBuff.writeZero(4);
                ListSerializer.serializeList(bucket.getAction(), TypeKeyMakerFactory.createActionKeyMaker(message.getVersion()), this.registry, bucketBuff);
                bucketBuff.setShort(0, bucketBuff.readableBytes());
                groupDescBuff.writeBytes(bucketBuff);
            }
            groupDescBuff.setShort(0, groupDescBuff.readableBytes());
            outBuffer.writeBytes(groupDescBuff);
        }
    }

    private void serializeGroupBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyGroupCase groupCase = (MultipartReplyGroupCase)body;
        MultipartReplyGroup group = groupCase.getMultipartReplyGroup();
        for (GroupStats groupStats : group.getGroupStats()) {
            ByteBuf groupStatsBuff = UnpooledByteBufAllocator.DEFAULT.buffer();
            groupStatsBuff.writeShort(0);
            groupStatsBuff.writeZero(2);
            groupStatsBuff.writeInt(groupStats.getGroupId().getValue().intValue());
            groupStatsBuff.writeInt(groupStats.getRefCount().intValue());
            groupStatsBuff.writeZero(4);
            groupStatsBuff.writeLong(groupStats.getPacketCount().longValue());
            groupStatsBuff.writeLong(groupStats.getByteCount().longValue());
            groupStatsBuff.writeInt(groupStats.getDurationSec().intValue());
            groupStatsBuff.writeInt(groupStats.getDurationNsec().intValue());
            for (BucketStats bucketStats : groupStats.getBucketStats()) {
                groupStatsBuff.writeLong(bucketStats.getPacketCount().longValue());
                groupStatsBuff.writeLong(bucketStats.getByteCount().longValue());
            }
            groupStatsBuff.setShort(0, groupStatsBuff.readableBytes());
            outBuffer.writeBytes(groupStatsBuff);
        }
    }

    private void serializeQueueBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyQueueCase queueCase = (MultipartReplyQueueCase)body;
        MultipartReplyQueue queue = queueCase.getMultipartReplyQueue();
        for (QueueStats queueStats : queue.getQueueStats()) {
            outBuffer.writeInt(queueStats.getPortNo().intValue());
            outBuffer.writeInt(queueStats.getQueueId().intValue());
            outBuffer.writeLong(queueStats.getTxBytes().longValue());
            outBuffer.writeLong(queueStats.getTxPackets().longValue());
            outBuffer.writeLong(queueStats.getTxErrors().longValue());
            outBuffer.writeInt(queueStats.getDurationSec().intValue());
            outBuffer.writeInt(queueStats.getDurationNsec().intValue());
        }
    }

    private void serializePortStatsBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyPortStatsCase portStatsCase = (MultipartReplyPortStatsCase)body;
        MultipartReplyPortStats portStats = portStatsCase.getMultipartReplyPortStats();
        for (PortStats portStat : portStats.getPortStats()) {
            outBuffer.writeInt(portStat.getPortNo().intValue());
            outBuffer.writeZero(4);
            outBuffer.writeLong(portStat.getRxPackets().longValue());
            outBuffer.writeLong(portStat.getTxPackets().longValue());
            outBuffer.writeLong(portStat.getRxBytes().longValue());
            outBuffer.writeLong(portStat.getTxBytes().longValue());
            outBuffer.writeLong(portStat.getRxDropped().longValue());
            outBuffer.writeLong(portStat.getTxDropped().longValue());
            outBuffer.writeLong(portStat.getRxErrors().longValue());
            outBuffer.writeLong(portStat.getTxErrors().longValue());
            outBuffer.writeLong(portStat.getRxFrameErr().longValue());
            outBuffer.writeLong(portStat.getRxOverErr().longValue());
            outBuffer.writeLong(portStat.getRxCrcErr().longValue());
            outBuffer.writeLong(portStat.getCollisions().longValue());
            outBuffer.writeInt(portStat.getDurationSec().intValue());
            outBuffer.writeInt(portStat.getDurationNsec().intValue());
        }
    }

    private void serializeTableBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyTableCase tableCase = (MultipartReplyTableCase)body;
        MultipartReplyTable table = tableCase.getMultipartReplyTable();
        for (TableStats tableStats : table.getTableStats()) {
            outBuffer.writeByte((int)tableStats.getTableId().shortValue());
            outBuffer.writeZero(3);
            outBuffer.writeInt(tableStats.getActiveCount().intValue());
            outBuffer.writeLong(tableStats.getLookupCount().longValue());
            outBuffer.writeLong(tableStats.getMatchedCount().longValue());
        }
    }

    private void serializeAggregateBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyAggregateCase aggregateCase = (MultipartReplyAggregateCase)body;
        MultipartReplyAggregate aggregate = aggregateCase.getMultipartReplyAggregate();
        outBuffer.writeLong(aggregate.getPacketCount().longValue());
        outBuffer.writeLong(aggregate.getByteCount().longValue());
        outBuffer.writeInt(aggregate.getFlowCount().intValue());
        outBuffer.writeZero(4);
    }

    private void serializeFlowBody(MultipartReplyBody body, ByteBuf outBuffer, MultipartReplyMessage message) {
        MultipartReplyFlowCase flowCase = (MultipartReplyFlowCase)body;
        MultipartReplyFlow flow = flowCase.getMultipartReplyFlow();
        for (FlowStats flowStats : flow.getFlowStats()) {
            ByteBuf flowStatsBuff = UnpooledByteBufAllocator.DEFAULT.buffer();
            flowStatsBuff.writeShort(0);
            flowStatsBuff.writeByte((int)new Long(flowStats.getTableId().shortValue()).byteValue());
            flowStatsBuff.writeZero(1);
            flowStatsBuff.writeInt(flowStats.getDurationSec().intValue());
            flowStatsBuff.writeInt(flowStats.getDurationNsec().intValue());
            flowStatsBuff.writeShort(flowStats.getPriority().intValue());
            flowStatsBuff.writeShort(flowStats.getIdleTimeout().intValue());
            flowStatsBuff.writeShort(flowStats.getHardTimeout().intValue());
            flowStatsBuff.writeZero(6);
            flowStatsBuff.writeLong(flowStats.getCookie().longValue());
            flowStatsBuff.writeLong(flowStats.getPacketCount().longValue());
            flowStatsBuff.writeLong(flowStats.getByteCount().longValue());
            OFSerializer matchSerializer = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(message.getVersion().shortValue(), Match.class));
            matchSerializer.serialize((DataContainer)flowStats.getMatch(), flowStatsBuff);
            ListSerializer.serializeList(flowStats.getInstruction(), TypeKeyMakerFactory.createInstructionKeyMaker(message.getVersion()), this.registry, flowStatsBuff);
            flowStatsBuff.setShort(0, flowStatsBuff.readableBytes());
            outBuffer.writeBytes(flowStatsBuff);
        }
    }

    private void serializeDescBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyDescCase descCase = (MultipartReplyDescCase)body;
        MultipartReplyDesc desc = descCase.getMultipartReplyDesc();
        this.write256String(desc.getMfrDesc(), outBuffer);
        this.write256String(desc.getHwDesc(), outBuffer);
        this.write256String(desc.getSwDesc(), outBuffer);
        this.write32String(desc.getSerialNum(), outBuffer);
        this.write256String(desc.getDpDesc(), outBuffer);
    }

    private void write256String(String toWrite, ByteBuf outBuffer) {
        byte[] nameBytes = toWrite.getBytes();
        if (nameBytes.length < 256) {
            byte[] nameBytesPadding = new byte[256];
            int i = 0;
            byte[] arr$ = nameBytes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                byte b;
                nameBytesPadding[i] = b = arr$[i$];
                ++i;
            }
            while (i < 256) {
                nameBytesPadding[i] = 0;
                ++i;
            }
            outBuffer.writeBytes(nameBytesPadding);
        } else {
            outBuffer.writeBytes(nameBytes);
        }
    }

    private void write32String(String toWrite, ByteBuf outBuffer) {
        byte[] nameBytes = toWrite.getBytes();
        if (nameBytes.length < 32) {
            byte[] nameBytesPadding = new byte[32];
            int i = 0;
            byte[] arr$ = nameBytes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                byte b;
                nameBytesPadding[i] = b = arr$[i$];
                ++i;
            }
            while (i < 32) {
                nameBytesPadding[i] = 0;
                ++i;
            }
            outBuffer.writeBytes(nameBytesPadding);
        } else {
            outBuffer.writeBytes(nameBytes);
        }
    }

    private void serializePortDescBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyPortDescCase portCase = (MultipartReplyPortDescCase)body;
        MultipartReplyPortDesc portDesc = portCase.getMultipartReplyPortDesc();
        for (Ports port : portDesc.getPorts()) {
            outBuffer.writeInt(port.getPortNo().intValue());
            outBuffer.writeZero(4);
            this.writeMacAddress(port.getHwAddr().getValue(), outBuffer);
            outBuffer.writeZero(2);
            this.writeName(port.getName(), outBuffer);
            this.writePortConfig(port.getConfig(), outBuffer);
            this.writePortState(port.getState(), outBuffer);
            this.writePortFeatures(port.getCurrentFeatures(), outBuffer);
            this.writePortFeatures(port.getAdvertisedFeatures(), outBuffer);
            this.writePortFeatures(port.getSupportedFeatures(), outBuffer);
            this.writePortFeatures(port.getPeerFeatures(), outBuffer);
            outBuffer.writeInt(port.getCurrSpeed().intValue());
            outBuffer.writeInt(port.getMaxSpeed().intValue());
        }
    }

    private void writeName(String name, ByteBuf outBuffer) {
        byte[] nameBytes = name.getBytes();
        if (nameBytes.length < 16) {
            byte[] nameBytesPadding = new byte[16];
            int i = 0;
            byte[] arr$ = nameBytes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                byte b;
                nameBytesPadding[i] = b = arr$[i$];
                ++i;
            }
            while (i < 16) {
                nameBytesPadding[i] = 0;
                ++i;
            }
            outBuffer.writeBytes(nameBytesPadding);
        } else {
            outBuffer.writeBytes(nameBytes);
        }
    }

    private void writeMacAddress(String macAddress, ByteBuf outBuffer) {
        String[] macAddressParts = macAddress.split(":");
        byte[] macAddressBytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            Integer hex = Integer.parseInt(macAddressParts[i], 16);
            macAddressBytes[i] = hex.byteValue();
        }
        outBuffer.writeBytes(macAddressBytes);
    }

    private void writePortConfig(PortConfig config, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, config.isPortDown());
        map.put(2, config.isNoRecv());
        map.put(5, config.isNoFwd());
        map.put(6, config.isNoPacketIn());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }

    private void writePortState(PortState state, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, state.isLinkDown());
        map.put(1, state.isBlocked());
        map.put(2, state.isLive());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }

    private void writePortFeatures(PortFeatures features, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, features.is_10mbHd());
        map.put(1, features.is_10mbFd());
        map.put(2, features.is_100mbHd());
        map.put(3, features.is_100mbFd());
        map.put(4, features.is_1gbHd());
        map.put(5, features.is_1gbFd());
        map.put(6, features.is_10gbFd());
        map.put(7, features.is_40gbFd());
        map.put(8, features.is_100gbFd());
        map.put(9, features.is_1tbFd());
        map.put(10, features.isOther());
        map.put(11, features.isCopper());
        map.put(12, features.isFiber());
        map.put(13, features.isAutoneg());
        map.put(14, features.isPause());
        map.put(15, features.isPauseAsym());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }
}

