/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.util.ListSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMakerFactory;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.openflowjava.util.ExperimenterSerializerKeyFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ActionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ExperimenterIdTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.InstructionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.NextTableRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.OxmRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.table.features.properties.container.table.feature.properties.NextTableIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableFeaturesPropType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterConfigCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.aggregate._case.MultipartRequestAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.experimenter._case.MultipartRequestExperimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.flow._case.MultipartRequestFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.group._case.MultipartRequestGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.meter._case.MultipartRequestMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.meter.config._case.MultipartRequestMeterConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.port.stats._case.MultipartRequestPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.queue._case.MultipartRequestQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.MultipartRequestTableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.multipart.request.table.features.TableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeatureProperties;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class MultipartRequestInputFactory
implements OFSerializer<MultipartRequestInput>,
SerializerRegistryInjector {
    private static final byte MESSAGE_TYPE = 18;
    private static final byte PADDING_IN_MULTIPART_REQUEST_MESSAGE = 4;
    private static final byte INSTRUCTIONS_CODE = 0;
    private static final byte INSTRUCTIONS_MISS_CODE = 1;
    private static final byte NEXT_TABLE_CODE = 2;
    private static final byte NEXT_TABLE_MISS_CODE = 3;
    private static final byte WRITE_ACTIONS_CODE = 4;
    private static final byte WRITE_ACTIONS_MISS_CODE = 5;
    private static final byte APPLY_ACTIONS_CODE = 6;
    private static final byte APPLY_ACTIONS_MISS_CODE = 7;
    private static final byte MATCH_CODE = 8;
    private static final byte WILDCARDS_CODE = 10;
    private static final byte WRITE_SETFIELD_CODE = 12;
    private static final byte WRITE_SETFIELD_MISS_CODE = 13;
    private static final byte APPLY_SETFIELD_CODE = 14;
    private static final byte APPLY_SETFIELD_MISS_CODE = 15;
    private static final byte PADDING_IN_MULTIPART_REQUEST_FLOW_BODY_01 = 3;
    private static final byte PADDING_IN_MULTIPART_REQUEST_FLOW_BODY_02 = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_AGREGGATE_BODY_01 = 3;
    private static final byte PADDING_IN_MULTIPART_REQUEST_AGREGGATE_BODY_02 = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_PORTSTATS_BODY = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_GROUP_BODY = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_METER_BODY = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_METER_CONFIG_BODY = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_TABLE_FEATURES_BODY = 5;
    private SerializerRegistry registry;

    public void serialize(MultipartRequestInput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)18, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeShort(message.getType().getIntValue());
        outBuffer.writeShort(MultipartRequestInputFactory.createMultipartRequestFlagsBitmask(message.getFlags()));
        outBuffer.writeZero(4);
        if (message.getMultipartRequestBody() instanceof MultipartRequestDescCase) {
            this.serializeDescBody();
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestFlowCase) {
            this.serializeFlowBody(message.getMultipartRequestBody(), outBuffer);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestAggregateCase) {
            this.serializeAggregateBody(message.getMultipartRequestBody(), outBuffer);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestTableCase) {
            this.serializeTableBody();
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestPortStatsCase) {
            MultipartRequestInputFactory.serializePortStatsBody(message.getMultipartRequestBody(), outBuffer);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestQueueCase) {
            MultipartRequestInputFactory.serializeQueueBody(message.getMultipartRequestBody(), outBuffer);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestGroupCase) {
            MultipartRequestInputFactory.serializeeGroupStatsBody(message.getMultipartRequestBody(), outBuffer);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestGroupDescCase) {
            this.serializeGroupDescBody();
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestGroupFeaturesCase) {
            this.serializeGroupFeaturesBody();
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestMeterCase) {
            MultipartRequestInputFactory.serializeMeterBody(message.getMultipartRequestBody(), outBuffer);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestMeterConfigCase) {
            MultipartRequestInputFactory.serializeMeterConfigBody(message.getMultipartRequestBody(), outBuffer);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestMeterFeaturesCase) {
            this.serializeMeterFeaturesBody();
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestTableFeaturesCase) {
            this.serializeTableFeaturesBody(message.getMultipartRequestBody(), outBuffer);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestPortDescCase) {
            this.serializePortDescBody();
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestExperimenterCase) {
            this.serializeExperimenterBody(message, outBuffer);
        }
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private void serializeExperimenterBody(MultipartRequestInput message, ByteBuf outBuffer) {
        MultipartRequestExperimenterCase expCase = (MultipartRequestExperimenterCase)message.getMultipartRequestBody();
        MultipartRequestExperimenter experimenter = expCase.getMultipartRequestExperimenter();
        long expId = experimenter.getExperimenter().getValue();
        long expType = experimenter.getExpType();
        outBuffer.writeInt((int)expId);
        outBuffer.writeInt((int)expType);
        OFSerializer serializer = (OFSerializer)this.registry.getSerializer((MessageTypeKey)ExperimenterSerializerKeyFactory.createMultipartRequestSerializerKey((short)4, (long)expId, (long)expType));
        serializer.serialize((DataContainer)experimenter.getExperimenterDataOfChoice(), outBuffer);
    }

    private static int createMultipartRequestFlagsBitmask(MultipartRequestFlags flags) {
        return ByteBufUtils.fillBitMask((int)0, (boolean[])new boolean[]{flags.isOFPMPFREQMORE()});
    }

    private void serializeDescBody() {
    }

    private void serializeTableBody() {
    }

    private void serializeGroupDescBody() {
    }

    private void serializeGroupFeaturesBody() {
    }

    private void serializeMeterFeaturesBody() {
    }

    private void serializePortDescBody() {
    }

    private void serializeFlowBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestFlowCase flowCase = (MultipartRequestFlowCase)multipartRequestBody;
        MultipartRequestFlow flow = flowCase.getMultipartRequestFlow();
        output.writeByte((int)flow.getTableId().byteValue());
        output.writeZero(3);
        output.writeInt(flow.getOutPort().intValue());
        output.writeInt(flow.getOutGroup().intValue());
        output.writeZero(4);
        output.writeLong(flow.getCookie().longValue());
        output.writeLong(flow.getCookieMask().longValue());
        OFSerializer serializer = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, Match.class));
        serializer.serialize((DataContainer)flow.getMatch(), output);
    }

    private void serializeAggregateBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestAggregateCase aggregateCase = (MultipartRequestAggregateCase)multipartRequestBody;
        MultipartRequestAggregate aggregate = aggregateCase.getMultipartRequestAggregate();
        output.writeByte((int)aggregate.getTableId().byteValue());
        output.writeZero(3);
        output.writeInt(aggregate.getOutPort().intValue());
        output.writeInt(aggregate.getOutGroup().intValue());
        output.writeZero(4);
        output.writeLong(aggregate.getCookie().longValue());
        output.writeLong(aggregate.getCookieMask().longValue());
        OFSerializer serializer = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, Match.class));
        serializer.serialize((DataContainer)aggregate.getMatch(), output);
    }

    private static void serializePortStatsBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestPortStatsCase portstatsCase = (MultipartRequestPortStatsCase)multipartRequestBody;
        MultipartRequestPortStats portstats = portstatsCase.getMultipartRequestPortStats();
        output.writeInt(portstats.getPortNo().intValue());
        output.writeZero(4);
    }

    private static void serializeQueueBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestQueueCase queueCase = (MultipartRequestQueueCase)multipartRequestBody;
        MultipartRequestQueue queue = queueCase.getMultipartRequestQueue();
        output.writeInt(queue.getPortNo().intValue());
        output.writeInt(queue.getQueueId().intValue());
    }

    private static void serializeeGroupStatsBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestGroupCase groupStatsCase = (MultipartRequestGroupCase)multipartRequestBody;
        MultipartRequestGroup groupStats = groupStatsCase.getMultipartRequestGroup();
        output.writeInt(groupStats.getGroupId().getValue().intValue());
        output.writeZero(4);
    }

    private static void serializeMeterBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestMeterCase meterCase = (MultipartRequestMeterCase)multipartRequestBody;
        MultipartRequestMeter meter = meterCase.getMultipartRequestMeter();
        output.writeInt(meter.getMeterId().getValue().intValue());
        output.writeZero(4);
    }

    private static void serializeMeterConfigBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestMeterConfigCase meterConfigCase = (MultipartRequestMeterConfigCase)multipartRequestBody;
        MultipartRequestMeterConfig meterConfig = meterConfigCase.getMultipartRequestMeterConfig();
        output.writeInt(meterConfig.getMeterId().getValue().intValue());
        output.writeZero(4);
    }

    private void serializeTableFeaturesBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestTableFeaturesCase tableFeaturesCase;
        MultipartRequestTableFeatures tableFeatures;
        if (multipartRequestBody != null && (tableFeatures = (tableFeaturesCase = (MultipartRequestTableFeaturesCase)multipartRequestBody).getMultipartRequestTableFeatures()).getTableFeatures() != null) {
            for (TableFeatures currTableFeature : tableFeatures.getTableFeatures()) {
                int tableFeatureLengthIndex = output.writerIndex();
                output.writeShort(0);
                output.writeByte((int)currTableFeature.getTableId().shortValue());
                output.writeZero(5);
                output.writeBytes(currTableFeature.getName().getBytes());
                output.writeZero(32 - currTableFeature.getName().getBytes().length);
                output.writeLong(currTableFeature.getMetadataMatch().longValue());
                output.writeLong(currTableFeature.getMetadataWrite().longValue());
                output.writeInt(MultipartRequestInputFactory.createTableConfigBitmask(currTableFeature.getConfig()));
                output.writeInt(currTableFeature.getMaxEntries().intValue());
                this.writeTableFeatureProperties(output, currTableFeature.getTableFeatureProperties());
                output.setShort(tableFeatureLengthIndex, output.writerIndex() - tableFeatureLengthIndex);
            }
        }
    }

    private void writeTableFeatureProperties(ByteBuf output, List<TableFeatureProperties> props) {
        if (props != null) {
            for (TableFeatureProperties property : props) {
                TableFeaturesPropType type = property.getType();
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTINSTRUCTIONS)) {
                    this.writeInstructionRelatedTableProperty(output, property, (byte)0);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTINSTRUCTIONSMISS)) {
                    this.writeInstructionRelatedTableProperty(output, property, (byte)1);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTNEXTTABLES)) {
                    MultipartRequestInputFactory.writeNextTableRelatedTableProperty(output, property, (byte)2);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTNEXTTABLESMISS)) {
                    MultipartRequestInputFactory.writeNextTableRelatedTableProperty(output, property, (byte)3);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTWRITEACTIONS)) {
                    this.writeActionsRelatedTableProperty(output, property, (byte)4);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTWRITEACTIONSMISS)) {
                    this.writeActionsRelatedTableProperty(output, property, (byte)5);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYACTIONS)) {
                    this.writeActionsRelatedTableProperty(output, property, (byte)6);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYACTIONSMISS)) {
                    this.writeActionsRelatedTableProperty(output, property, (byte)7);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTMATCH)) {
                    this.writeOxmRelatedTableProperty(output, property, (byte)8);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTWILDCARDS)) {
                    this.writeOxmRelatedTableProperty(output, property, (byte)10);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTWRITESETFIELD)) {
                    this.writeOxmRelatedTableProperty(output, property, (byte)12);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTWRITESETFIELDMISS)) {
                    this.writeOxmRelatedTableProperty(output, property, (byte)13);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYSETFIELD)) {
                    this.writeOxmRelatedTableProperty(output, property, (byte)14);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYSETFIELDMISS)) {
                    this.writeOxmRelatedTableProperty(output, property, (byte)15);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTEXPERIMENTER)) {
                    this.writeExperimenterRelatedTableProperty(output, property);
                    continue;
                }
                if (!type.equals((Object)TableFeaturesPropType.OFPTFPTEXPERIMENTERMISS)) continue;
                this.writeExperimenterRelatedTableProperty(output, property);
            }
        }
    }

    private void writeInstructionRelatedTableProperty(ByteBuf output, TableFeatureProperties property, byte code) {
        int startIndex = output.writerIndex();
        output.writeShort((int)code);
        int lengthIndex = output.writerIndex();
        output.writeShort(0);
        List instructions = ((InstructionRelatedTableFeatureProperty)property.getAugmentation(InstructionRelatedTableFeatureProperty.class)).getInstruction();
        if (instructions != null) {
            TypeKeyMaker<Instruction> keyMaker = TypeKeyMakerFactory.createInstructionKeyMaker((short)4);
            ListSerializer.serializeHeaderList(instructions, keyMaker, this.registry, output);
        }
        int length = output.writerIndex() - startIndex;
        output.setShort(lengthIndex, length);
        output.writeZero(MultipartRequestInputFactory.paddingNeeded(length));
    }

    private static void writeNextTableRelatedTableProperty(ByteBuf output, TableFeatureProperties property, byte code) {
        int startIndex = output.writerIndex();
        output.writeShort((int)code);
        int lengthIndex = output.writerIndex();
        output.writeShort(0);
        List nextTableIds = ((NextTableRelatedTableFeatureProperty)property.getAugmentation(NextTableRelatedTableFeatureProperty.class)).getNextTableIds();
        if (nextTableIds != null) {
            for (NextTableIds next : nextTableIds) {
                output.writeByte((int)next.getTableId().shortValue());
            }
        }
        int length = output.writerIndex() - startIndex;
        output.setShort(lengthIndex, length);
        output.writeZero(MultipartRequestInputFactory.paddingNeeded(length));
    }

    private static int paddingNeeded(int length) {
        int paddingRemainder = length % 8;
        int result = 0;
        if (paddingRemainder != 0) {
            result = 8 - paddingRemainder;
        }
        return result;
    }

    private void writeActionsRelatedTableProperty(ByteBuf output, TableFeatureProperties property, byte code) {
        int startIndex = output.writerIndex();
        output.writeShort((int)code);
        int lengthIndex = output.writerIndex();
        output.writeShort(0);
        List actions = ((ActionRelatedTableFeatureProperty)property.getAugmentation(ActionRelatedTableFeatureProperty.class)).getAction();
        if (actions != null) {
            TypeKeyMaker<Action> keyMaker = TypeKeyMakerFactory.createActionKeyMaker((short)4);
            ListSerializer.serializeHeaderList(actions, keyMaker, this.registry, output);
        }
        int length = output.writerIndex() - startIndex;
        output.setShort(lengthIndex, length);
        output.writeZero(MultipartRequestInputFactory.paddingNeeded(length));
    }

    private void writeOxmRelatedTableProperty(ByteBuf output, TableFeatureProperties property, byte code) {
        int startIndex = output.writerIndex();
        output.writeShort((int)code);
        int lengthIndex = output.writerIndex();
        output.writeShort(0);
        List entries = ((OxmRelatedTableFeatureProperty)property.getAugmentation(OxmRelatedTableFeatureProperty.class)).getMatchEntry();
        if (entries != null) {
            TypeKeyMaker<MatchEntry> keyMaker = TypeKeyMakerFactory.createMatchEntriesKeyMaker((short)4);
            ListSerializer.serializeHeaderList(entries, keyMaker, this.registry, output);
        }
        int length = output.writerIndex() - startIndex;
        output.setShort(lengthIndex, length);
        output.writeZero(MultipartRequestInputFactory.paddingNeeded(length));
    }

    private void writeExperimenterRelatedTableProperty(ByteBuf output, TableFeatureProperties property) {
        long expId = ((ExperimenterIdTableFeatureProperty)property.getAugmentation(ExperimenterIdTableFeatureProperty.class)).getExperimenter().getValue();
        OFSerializer serializer = (OFSerializer)this.registry.getSerializer((MessageTypeKey)ExperimenterSerializerKeyFactory.createMultipartRequestTFSerializerKey((short)4, (long)expId));
        serializer.serialize((DataContainer)property, output);
    }

    private static int createTableConfigBitmask(TableConfig tableConfig) {
        return ByteBufUtils.fillBitMask((int)3, (boolean[])new boolean[]{tableConfig.isOFPTCDEPRECATEDMASK()});
    }

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }
}

