/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ActionTypeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.CapabilitiesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortStateV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.features.reply.PhyPort;

public class OF10FeaturesReplyMessageFactory
implements OFSerializer<GetFeaturesOutput> {
    private static final byte PADDING = 3;
    private static final byte MESSAGE_TYPE = 6;

    public void serialize(GetFeaturesOutput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)6, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeLong(message.getDatapathId().longValue());
        outBuffer.writeInt(message.getBuffers().intValue());
        outBuffer.writeByte(message.getTables().intValue());
        outBuffer.writeZero(3);
        outBuffer.writeInt(OF10FeaturesReplyMessageFactory.createCapabilities(message.getCapabilitiesV10()));
        outBuffer.writeInt(OF10FeaturesReplyMessageFactory.createActionsV10(message.getActionsV10()));
        for (PhyPort port : message.getPhyPort()) {
            outBuffer.writeShort(port.getPortNo().intValue());
            this.writeMacAddress(port.getHwAddr().getValue(), outBuffer);
            this.writeName(port.getName(), outBuffer);
            this.writePortConfig(port.getConfigV10(), outBuffer);
            this.writePortState(port.getStateV10(), outBuffer);
            this.writePortFeature(port.getCurrentFeaturesV10(), outBuffer);
            this.writePortFeature(port.getAdvertisedFeaturesV10(), outBuffer);
            this.writePortFeature(port.getSupportedFeaturesV10(), outBuffer);
            this.writePortFeature(port.getPeerFeaturesV10(), outBuffer);
        }
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private void writePortFeature(PortFeaturesV10 feature, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, feature.is_10mbHd());
        map.put(1, feature.is_10mbFd());
        map.put(2, feature.is_100mbHd());
        map.put(3, feature.is_100mbFd());
        map.put(4, feature.is_1gbHd());
        map.put(5, feature.is_1gbFd());
        map.put(6, feature.is_10gbFd());
        map.put(7, feature.isCopper());
        map.put(8, feature.isFiber());
        map.put(9, feature.isAutoneg());
        map.put(10, feature.isPause());
        map.put(11, feature.isPauseAsym());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }

    private void writePortState(PortStateV10 state, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, state.isLinkDown());
        map.put(1, state.isBlocked());
        map.put(2, state.isLive());
        map.put(3, state.isStpListen());
        map.put(4, state.isStpLearn());
        map.put(5, state.isStpForward());
        map.put(6, state.isStpBlock());
        map.put(7, state.isStpMask());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }

    private void writePortConfig(PortConfigV10 config, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, config.isPortDown());
        map.put(1, config.isNoStp());
        map.put(2, config.isNoRecv());
        map.put(3, config.isNoRecvStp());
        map.put(4, config.isNoFlood());
        map.put(5, config.isNoFwd());
        map.put(6, config.isNoPacketIn());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }

    private static int createCapabilities(CapabilitiesV10 capabilities) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, capabilities.isOFPCFLOWSTATS());
        map.put(1, capabilities.isOFPCTABLESTATS());
        map.put(2, capabilities.isOFPCPORTSTATS());
        map.put(3, capabilities.isOFPCSTP());
        map.put(4, capabilities.isOFPCRESERVED());
        map.put(5, capabilities.isOFPCIPREASM());
        map.put(6, capabilities.isOFPCQUEUESTATS());
        map.put(7, capabilities.isOFPCARPMATCHIP());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        return bitmap;
    }

    private static int createActionsV10(ActionTypeV10 action) {
        return ByteBufUtils.fillBitMask((int)0, (boolean[])new boolean[]{action.isOFPATOUTPUT(), action.isOFPATSETVLANVID(), action.isOFPATSETVLANPCP(), action.isOFPATSTRIPVLAN(), action.isOFPATSETDLSRC(), action.isOFPATSETDLDST(), action.isOFPATSETNWSRC(), action.isOFPATSETNWDST(), action.isOFPATSETNWTOS(), action.isOFPATSETTPSRC(), action.isOFPATSETTPDST(), action.isOFPATENQUEUE(), action.isOFPATVENDOR()});
    }

    private void writeMacAddress(String macAddress, ByteBuf outBuffer) {
        String[] macAddressParts = macAddress.split(":");
        byte[] macAddressBytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            Integer hex = Integer.parseInt(macAddressParts[i], 16);
            macAddressBytes[i] = hex.byteValue();
        }
        outBuffer.writeBytes(macAddressBytes);
    }

    private void writeName(String name, ByteBuf outBuffer) {
        byte[] nameBytes = name.getBytes();
        if (nameBytes.length < 16) {
            byte[] nameBytesPadding = new byte[16];
            int i = 0;
            byte[] arr$ = nameBytes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                byte b;
                nameBytesPadding[i] = b = arr$[i$];
                ++i;
            }
            while (i < 16) {
                nameBytesPadding[i] = 0;
                ++i;
            }
            outBuffer.writeBytes(nameBytesPadding);
        } else {
            outBuffer.writeBytes(nameBytes);
        }
    }
}

