/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.util.ListSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMakerFactory;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlagsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10FlowModInputMessageFactory
implements OFSerializer<FlowModInput>,
SerializerRegistryInjector {
    private static final byte MESSAGE_TYPE = 14;
    private static final TypeKeyMaker<Action> ACTION_KEY_MAKER = TypeKeyMakerFactory.createActionKeyMaker((short)1);
    private SerializerRegistry registry;

    public void serialize(FlowModInput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)14, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        OFSerializer matchSerializer = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(message.getVersion().shortValue(), MatchV10.class));
        matchSerializer.serialize((DataContainer)message.getMatchV10(), outBuffer);
        outBuffer.writeLong(message.getCookie().longValue());
        outBuffer.writeShort(message.getCommand().getIntValue());
        outBuffer.writeShort(message.getIdleTimeout().intValue());
        outBuffer.writeShort(message.getHardTimeout().intValue());
        outBuffer.writeShort(message.getPriority().intValue());
        outBuffer.writeInt(message.getBufferId().intValue());
        outBuffer.writeShort(message.getOutPort().getValue().intValue());
        outBuffer.writeShort(OF10FlowModInputMessageFactory.createFlowModFlagsBitmask(message.getFlagsV10()));
        ListSerializer.serializeList(message.getAction(), ACTION_KEY_MAKER, this.registry, outBuffer);
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private static int createFlowModFlagsBitmask(FlowModFlagsV10 flags) {
        return ByteBufUtils.fillBitMask((int)0, (boolean[])new boolean[]{flags.isOFPFFSENDFLOWREM(), flags.isOFPFFCHECKOVERLAP(), flags.isOFPFFEMERG()});
    }

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }
}

