/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10FlowRemovedMessageFactory
implements OFSerializer<FlowRemovedMessage>,
SerializerRegistryInjector {
    private static final byte MESSAGE_TYPE = 11;
    private SerializerRegistry registry;
    private static final byte PADDING = 1;

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }

    public void serialize(FlowRemovedMessage message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)11, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        OFSerializer matchSerializer = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(message.getVersion().shortValue(), MatchV10.class));
        matchSerializer.serialize((DataContainer)message.getMatchV10(), outBuffer);
        outBuffer.writeLong(message.getCookie().longValue());
        outBuffer.writeShort(message.getPriority().intValue());
        outBuffer.writeByte(message.getReason().getIntValue());
        outBuffer.writeZero(1);
        outBuffer.writeInt(message.getDurationSec().intValue());
        outBuffer.writeInt(message.getDurationNsec().intValue());
        outBuffer.writeShort(message.getIdleTimeout().intValue());
        outBuffer.writeZero(1);
        outBuffer.writeZero(1);
        outBuffer.writeLong(message.getPacketCount().longValue());
        outBuffer.writeLong(message.getByteCount().longValue());
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }
}

