/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;

public class OF10PacketInMessageFactory
implements OFSerializer<PacketInMessage> {
    private static final byte MESSAGE_TYPE = 10;
    private static final byte PADDING = 1;

    public void serialize(PacketInMessage message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)10, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeInt(message.getBufferId().intValue());
        outBuffer.writeShort(message.getTotalLen().intValue());
        outBuffer.writeShort(message.getInPort().intValue());
        outBuffer.writeByte(message.getReason().getIntValue());
        outBuffer.writeZero(1);
        byte[] data = message.getData();
        if (data != null) {
            outBuffer.writeBytes(data);
        }
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }
}

