/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.impl.util.ListSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMakerFactory;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;

public class OF10PacketOutInputMessageFactory
implements OFSerializer<PacketOutInput>,
SerializerRegistryInjector {
    private static final byte MESSAGE_TYPE = 13;
    private SerializerRegistry registry;

    public void serialize(PacketOutInput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)13, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeInt(message.getBufferId().intValue());
        outBuffer.writeShort(message.getInPort().getValue().intValue());
        int actionsLengthIndex = outBuffer.writerIndex();
        outBuffer.writeShort(0);
        int actionsStartIndex = outBuffer.writerIndex();
        ListSerializer.serializeList(message.getAction(), TypeKeyMakerFactory.createActionKeyMaker((short)1), this.registry, outBuffer);
        outBuffer.setShort(actionsLengthIndex, outBuffer.writerIndex() - actionsStartIndex);
        byte[] data = message.getData();
        if (data != null) {
            outBuffer.writeBytes(data);
        }
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }
}

