/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;

public class OF10PortModInputMessageFactory
implements OFSerializer<PortModInput> {
    private static final byte MESSAGE_TYPE = 15;
    private static final byte PADDING_IN_PORT_MOD_MESSAGE = 4;

    public void serialize(PortModInput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)15, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeShort(message.getPortNo().getValue().intValue());
        outBuffer.writeBytes(ByteBufUtils.macAddressToBytes((String)message.getHwAddress().getValue()));
        outBuffer.writeInt(OF10PortModInputMessageFactory.createPortConfigBitmask(message.getConfigV10()));
        outBuffer.writeInt(OF10PortModInputMessageFactory.createPortConfigBitmask(message.getMaskV10()));
        outBuffer.writeInt(OF10PortModInputMessageFactory.createPortFeaturesBitmask(message.getAdvertiseV10()));
        outBuffer.writeZero(4);
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private static int createPortConfigBitmask(PortConfigV10 config) {
        return ByteBufUtils.fillBitMask((int)0, (boolean[])new boolean[]{config.isPortDown(), config.isNoStp(), config.isNoRecv(), config.isNoRecvStp(), config.isNoFlood(), config.isNoFwd(), config.isNoPacketIn()});
    }

    private static int createPortFeaturesBitmask(PortFeaturesV10 feature) {
        return ByteBufUtils.fillBitMask((int)0, (boolean[])new boolean[]{feature.is_10mbHd(), feature.is_10mbFd(), feature.is_100mbHd(), feature.is_100mbFd(), feature.is_1gbHd(), feature.is_1gbFd(), feature.is_10gbFd(), feature.isCopper(), feature.isFiber(), feature.isAutoneg(), feature.isPause(), feature.isPauseAsym()});
    }
}

