/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.RateQueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;

public class OF10QueueGetConfigReplyMessageFactory
implements OFSerializer<GetQueueConfigOutput> {
    private static final byte MESSAGE_TYPE = 21;
    private static final byte PADDING = 6;
    private static final int QUEUE_LENGTH_INDEX = 4;
    private static final byte QUEUE_PADDING = 2;
    private static final byte QUEUE_PROPERTY_PADDING = 6;
    private static final int QUEUE_PROPERTY_LENGTH_INDEX = 2;

    public void serialize(GetQueueConfigOutput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)21, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeShort(message.getPort().getValue().intValue());
        outBuffer.writeZero(6);
        for (Queues queue : message.getQueues()) {
            ByteBuf queueBuff = UnpooledByteBufAllocator.DEFAULT.buffer();
            queueBuff.writeInt(queue.getQueueId().getValue().intValue());
            queueBuff.writeShort(0);
            queueBuff.writeZero(2);
            for (QueueProperty queueProperty : queue.getQueueProperty()) {
                ByteBuf queuePropertyBuff = UnpooledByteBufAllocator.DEFAULT.buffer();
                queuePropertyBuff.writeShort(queueProperty.getProperty().getIntValue());
                queuePropertyBuff.writeShort(0);
                queuePropertyBuff.writeZero(4);
                if (queueProperty.getProperty() == QueueProperties.OFPQTMINRATE) {
                    RateQueueProperty body = (RateQueueProperty)queueProperty.getAugmentation(RateQueueProperty.class);
                    queuePropertyBuff.writeShort(body.getRate().intValue());
                    queuePropertyBuff.writeZero(6);
                }
                queuePropertyBuff.setShort(2, queuePropertyBuff.readableBytes());
                queueBuff.writeBytes(queuePropertyBuff);
            }
            queueBuff.setShort(4, queueBuff.readableBytes());
            outBuffer.writeBytes(queueBuff);
        }
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }
}

