/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.HashMap;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.util.ListSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMakerFactory;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.MultipartReplyBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.aggregate._case.MultipartReplyAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.desc._case.MultipartReplyDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.experimenter._case.MultipartReplyExperimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.MultipartReplyFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.MultipartReplyPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.MultipartReplyQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.MultipartReplyTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStats;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10StatsReplyMessageFactory
implements OFSerializer<MultipartReplyMessage>,
SerializerRegistryInjector {
    private SerializerRegistry registry;
    private static final byte MESSAGE_TYPE = 17;
    private static final byte FLOW_STATS_PADDING_1 = 1;
    private static final byte FLOW_STATS_PADDING_2 = 6;
    private static final TypeKeyMaker<Action> ACTION_KEY_MAKER = TypeKeyMakerFactory.createActionKeyMaker((short)1);
    private static final int FLOW_STATS_LENGTH_INDEX = 0;
    private static final int QUEUE_STATS_LENGTH_INDEX = 0;
    private static final byte AGGREGATE_PADDING = 4;
    private static final byte TABLE_PADDING = 3;
    private static final byte QUEUE_PADDING = 2;
    private static final byte PORT_STATS_PADDING = 6;

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }

    public void serialize(MultipartReplyMessage message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)17, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeShort(message.getType().getIntValue());
        this.writeFlags(message.getFlags(), outBuffer);
        switch (message.getType()) {
            case OFPMPDESC: {
                this.serializeDescBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPFLOW: {
                this.serializeFlowBody(message.getMultipartReplyBody(), outBuffer, message);
                break;
            }
            case OFPMPAGGREGATE: {
                this.serializeAggregateBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPTABLE: {
                this.serializeTableBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPPORTSTATS: {
                this.serializePortStatsBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPQUEUE: {
                this.serializeQueueBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
            case OFPMPEXPERIMENTER: {
                this.serializeExperimenterBody(message.getMultipartReplyBody(), outBuffer);
                break;
            }
        }
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private void serializeExperimenterBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyExperimenterCase experimenterCase = (MultipartReplyExperimenterCase)body;
        MultipartReplyExperimenter experimenterBody = experimenterCase.getMultipartReplyExperimenter();
    }

    private void serializeQueueBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyQueueCase queueCase = (MultipartReplyQueueCase)body;
        MultipartReplyQueue queue = queueCase.getMultipartReplyQueue();
        for (QueueStats queueStats : queue.getQueueStats()) {
            ByteBuf queueStatsBuff = UnpooledByteBufAllocator.DEFAULT.buffer();
            queueStatsBuff.writeShort(0);
            queueStatsBuff.writeZero(2);
            queueStatsBuff.writeInt(queueStats.getQueueId().intValue());
            queueStatsBuff.writeLong(queueStats.getTxBytes().longValue());
            queueStatsBuff.writeLong(queueStats.getTxPackets().longValue());
            queueStatsBuff.writeLong(queueStats.getTxErrors().longValue());
            queueStatsBuff.setShort(0, queueStatsBuff.readableBytes());
            outBuffer.writeBytes(queueStatsBuff);
        }
    }

    private void serializePortStatsBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyPortStatsCase portStatsCase = (MultipartReplyPortStatsCase)body;
        MultipartReplyPortStats portStats = portStatsCase.getMultipartReplyPortStats();
        for (PortStats portStat : portStats.getPortStats()) {
            outBuffer.writeInt(portStat.getPortNo().intValue());
            outBuffer.writeZero(6);
            outBuffer.writeLong(portStat.getRxPackets().longValue());
            outBuffer.writeLong(portStat.getTxPackets().longValue());
            outBuffer.writeLong(portStat.getRxBytes().longValue());
            outBuffer.writeLong(portStat.getTxBytes().longValue());
            outBuffer.writeLong(portStat.getRxDropped().longValue());
            outBuffer.writeLong(portStat.getTxDropped().longValue());
            outBuffer.writeLong(portStat.getRxErrors().longValue());
            outBuffer.writeLong(portStat.getTxErrors().longValue());
            outBuffer.writeLong(portStat.getRxFrameErr().longValue());
            outBuffer.writeLong(portStat.getRxOverErr().longValue());
            outBuffer.writeLong(portStat.getRxCrcErr().longValue());
            outBuffer.writeLong(portStat.getCollisions().longValue());
        }
    }

    private void serializeTableBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyTableCase tableCase = (MultipartReplyTableCase)body;
        MultipartReplyTable table = tableCase.getMultipartReplyTable();
        for (TableStats tableStats : table.getTableStats()) {
            outBuffer.writeByte((int)tableStats.getTableId().shortValue());
            outBuffer.writeZero(3);
            this.write16String(tableStats.getName(), outBuffer);
            this.writeFlowWildcardsV10(tableStats.getWildcards(), outBuffer);
            outBuffer.writeInt(tableStats.getMaxEntries().intValue());
            outBuffer.writeInt(tableStats.getActiveCount().intValue());
            outBuffer.writeLong(tableStats.getLookupCount().longValue());
            outBuffer.writeLong(tableStats.getMatchedCount().longValue());
        }
    }

    private void writeFlowWildcardsV10(FlowWildcardsV10 feature, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, feature.isINPORT());
        map.put(1, feature.isDLVLAN());
        map.put(2, feature.isDLSRC());
        map.put(3, feature.isDLDST());
        map.put(4, feature.isDLTYPE());
        map.put(5, feature.isNWPROTO());
        map.put(6, feature.isTPSRC());
        map.put(7, feature.isTPDST());
        map.put(20, feature.isDLVLANPCP());
        map.put(21, feature.isNWTOS());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }

    private void serializeAggregateBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyAggregateCase aggregateCase = (MultipartReplyAggregateCase)body;
        MultipartReplyAggregate aggregate = aggregateCase.getMultipartReplyAggregate();
        outBuffer.writeLong(aggregate.getPacketCount().longValue());
        outBuffer.writeLong(aggregate.getByteCount().longValue());
        outBuffer.writeInt(aggregate.getFlowCount().intValue());
        outBuffer.writeZero(4);
    }

    private void serializeFlowBody(MultipartReplyBody body, ByteBuf outBuffer, MultipartReplyMessage message) {
        MultipartReplyFlowCase flowCase = (MultipartReplyFlowCase)body;
        MultipartReplyFlow flow = flowCase.getMultipartReplyFlow();
        for (FlowStats flowStats : flow.getFlowStats()) {
            ByteBuf flowStatsBuff = UnpooledByteBufAllocator.DEFAULT.buffer();
            flowStatsBuff.writeShort(0);
            flowStatsBuff.writeByte((int)new Long(flowStats.getTableId().shortValue()).byteValue());
            flowStatsBuff.writeZero(1);
            OFSerializer matchSerializer = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(message.getVersion().shortValue(), MatchV10.class));
            matchSerializer.serialize((DataContainer)flowStats.getMatchV10(), flowStatsBuff);
            flowStatsBuff.writeInt(flowStats.getDurationSec().intValue());
            flowStatsBuff.writeInt(flowStats.getDurationNsec().intValue());
            flowStatsBuff.writeShort(flowStats.getPriority().intValue());
            flowStatsBuff.writeShort(flowStats.getIdleTimeout().intValue());
            flowStatsBuff.writeShort(flowStats.getHardTimeout().intValue());
            flowStatsBuff.writeZero(6);
            flowStatsBuff.writeLong(flowStats.getCookie().longValue());
            flowStatsBuff.writeLong(flowStats.getPacketCount().longValue());
            flowStatsBuff.writeLong(flowStats.getByteCount().longValue());
            ListSerializer.serializeList(flowStats.getAction(), ACTION_KEY_MAKER, this.registry, flowStatsBuff);
            flowStatsBuff.setShort(0, flowStatsBuff.readableBytes());
            outBuffer.writeBytes(flowStatsBuff);
        }
    }

    private void writeFlags(MultipartRequestFlags flags, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, flags.isOFPMPFREQMORE());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeShort(bitmap);
    }

    private void serializeDescBody(MultipartReplyBody body, ByteBuf outBuffer) {
        MultipartReplyDescCase descCase = (MultipartReplyDescCase)body;
        MultipartReplyDesc desc = descCase.getMultipartReplyDesc();
        this.write256String(desc.getMfrDesc(), outBuffer);
        this.write256String(desc.getHwDesc(), outBuffer);
        this.write256String(desc.getSwDesc(), outBuffer);
        this.write32String(desc.getSerialNum(), outBuffer);
        this.write256String(desc.getDpDesc(), outBuffer);
    }

    private void write256String(String toWrite, ByteBuf outBuffer) {
        byte[] nameBytes = toWrite.getBytes();
        if (nameBytes.length < 256) {
            byte[] nameBytesPadding = new byte[256];
            int i = 0;
            byte[] arr$ = nameBytes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                byte b;
                nameBytesPadding[i] = b = arr$[i$];
                ++i;
            }
            while (i < 256) {
                nameBytesPadding[i] = 0;
                ++i;
            }
            outBuffer.writeBytes(nameBytesPadding);
        } else {
            outBuffer.writeBytes(nameBytes);
        }
    }

    private void write16String(String toWrite, ByteBuf outBuffer) {
        byte[] nameBytes = toWrite.getBytes();
        if (nameBytes.length < 16) {
            byte[] nameBytesPadding = new byte[16];
            int i = 0;
            byte[] arr$ = nameBytes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                byte b;
                nameBytesPadding[i] = b = arr$[i$];
                ++i;
            }
            while (i < 16) {
                nameBytesPadding[i] = 0;
                ++i;
            }
            outBuffer.writeBytes(nameBytesPadding);
        } else {
            outBuffer.writeBytes(nameBytes);
        }
    }

    private void write32String(String toWrite, ByteBuf outBuffer) {
        byte[] nameBytes = toWrite.getBytes();
        if (nameBytes.length < 32) {
            byte[] nameBytesPadding = new byte[32];
            int i = 0;
            byte[] arr$ = nameBytes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                byte b;
                nameBytesPadding[i] = b = arr$[i$];
                ++i;
            }
            while (i < 32) {
                nameBytesPadding[i] = 0;
                ++i;
            }
            outBuffer.writeBytes(nameBytesPadding);
        } else {
            outBuffer.writeBytes(nameBytes);
        }
    }
}

