/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.openflowjava.util.ExperimenterSerializerKeyFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.aggregate._case.MultipartRequestAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.experimenter._case.MultipartRequestExperimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.flow._case.MultipartRequestFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.port.stats._case.MultipartRequestPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.queue._case.MultipartRequestQueue;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF10StatsRequestInputFactory
implements OFSerializer<MultipartRequestInput>,
SerializerRegistryInjector {
    private static final byte MESSAGE_TYPE = 16;
    private static final byte PADDING_IN_MULTIPART_REQUEST_FLOW_BODY = 1;
    private static final byte PADDING_IN_MULTIPART_REQUEST_AGGREGATE_BODY = 1;
    private static final byte PADDING_IN_MULTIPART_REQUEST_PORT_BODY = 6;
    private static final byte PADING_IN_QUEUE_BODY = 2;
    private SerializerRegistry registry;

    public void serialize(MultipartRequestInput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)16, (OfHeader)message, (ByteBuf)outBuffer, (int)8);
        outBuffer.writeShort(message.getType().getIntValue());
        outBuffer.writeShort(OF10StatsRequestInputFactory.createMultipartRequestFlagsBitmask(message.getFlags()));
        if (message.getMultipartRequestBody() instanceof MultipartRequestDescCase) {
            this.serializeDescBody();
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestFlowCase) {
            this.serializeFlowBody(message.getMultipartRequestBody(), outBuffer);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestAggregateCase) {
            this.serializeAggregateBody(message.getMultipartRequestBody(), outBuffer);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestTableCase) {
            this.serializeTableBody();
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestPortStatsCase) {
            OF10StatsRequestInputFactory.serializePortBody(message.getMultipartRequestBody(), outBuffer);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestQueueCase) {
            OF10StatsRequestInputFactory.serializeQueueBody(message.getMultipartRequestBody(), outBuffer);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestExperimenterCase) {
            this.serializeExperimenterBody(message.getMultipartRequestBody(), outBuffer);
        }
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private static int createMultipartRequestFlagsBitmask(MultipartRequestFlags flags) {
        return ByteBufUtils.fillBitMask((int)0, (boolean[])new boolean[]{flags.isOFPMPFREQMORE()});
    }

    private void serializeDescBody() {
    }

    private void serializeTableBody() {
    }

    private void serializeFlowBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestFlowCase flowCase = (MultipartRequestFlowCase)multipartRequestBody;
        MultipartRequestFlow flow = flowCase.getMultipartRequestFlow();
        OFSerializer matchSerializer = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(1, MatchV10.class));
        matchSerializer.serialize((DataContainer)flow.getMatchV10(), output);
        output.writeByte((int)flow.getTableId().shortValue());
        output.writeZero(1);
        output.writeShort(flow.getOutPort().intValue());
    }

    private void serializeAggregateBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestAggregateCase aggregateCase = (MultipartRequestAggregateCase)multipartRequestBody;
        MultipartRequestAggregate aggregate = aggregateCase.getMultipartRequestAggregate();
        OFSerializer matchSerializer = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(1, MatchV10.class));
        matchSerializer.serialize((DataContainer)aggregate.getMatchV10(), output);
        output.writeByte((int)aggregate.getTableId().shortValue());
        output.writeZero(1);
        output.writeShort(aggregate.getOutPort().intValue());
    }

    private static void serializePortBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestPortStatsCase portstatsCase = (MultipartRequestPortStatsCase)multipartRequestBody;
        MultipartRequestPortStats portstats = portstatsCase.getMultipartRequestPortStats();
        output.writeShort(portstats.getPortNo().intValue());
        output.writeZero(6);
    }

    private static void serializeQueueBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestQueueCase queueCase = (MultipartRequestQueueCase)multipartRequestBody;
        MultipartRequestQueue queue = queueCase.getMultipartRequestQueue();
        output.writeShort(queue.getPortNo().intValue());
        output.writeZero(2);
        output.writeInt(queue.getQueueId().intValue());
    }

    private void serializeExperimenterBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestExperimenterCase expCase = (MultipartRequestExperimenterCase)multipartRequestBody;
        MultipartRequestExperimenter experimenter = expCase.getMultipartRequestExperimenter();
        long expId = experimenter.getExperimenter().getValue();
        output.writeInt((int)expId);
        OFSerializer serializer = (OFSerializer)this.registry.getSerializer((MessageTypeKey)ExperimenterSerializerKeyFactory.createMultipartRequestSerializerKey((short)1, (long)expId, (long)-1L));
        serializer.serialize((DataContainer)experimenter.getExperimenterDataOfChoice(), output);
    }

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }
}

