/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class PacketInMessageFactory
implements OFSerializer<PacketInMessage>,
SerializerRegistryInjector {
    private static final byte PADDING = 2;
    private static final byte MESSAGE_TYPE = 10;
    private SerializerRegistry registry;

    public void serialize(PacketInMessage message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)10, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeInt(message.getBufferId().intValue());
        outBuffer.writeShort(message.getTotalLen().intValue());
        outBuffer.writeByte(message.getReason().getIntValue());
        outBuffer.writeByte((int)message.getTableId().getValue().byteValue());
        outBuffer.writeLong(message.getCookie().longValue());
        OFSerializer matchSerializer = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(message.getVersion().shortValue(), Match.class));
        matchSerializer.serialize((DataContainer)message.getMatch(), outBuffer);
        outBuffer.writeZero(2);
        byte[] data = message.getData();
        if (data != null) {
            outBuffer.writeBytes(data);
        }
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }
}

