/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;

public class PortModInputMessageFactory
implements OFSerializer<PortModInput> {
    private static final byte MESSAGE_TYPE = 16;
    private static final byte PADDING_IN_PORT_MOD_MESSAGE_01 = 4;
    private static final byte PADDING_IN_PORT_MOD_MESSAGE_02 = 2;
    private static final byte PADDING_IN_PORT_MOD_MESSAGE_03 = 4;

    public void serialize(PortModInput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)16, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeInt(message.getPortNo().getValue().intValue());
        outBuffer.writeZero(4);
        outBuffer.writeBytes(ByteBufUtils.macAddressToBytes((String)message.getHwAddress().getValue()));
        outBuffer.writeZero(2);
        outBuffer.writeInt(PortModInputMessageFactory.createPortConfigBitmask(message.getConfig()));
        outBuffer.writeInt(PortModInputMessageFactory.createPortConfigBitmask(message.getMask()));
        outBuffer.writeInt(PortModInputMessageFactory.createPortFeaturesBitmask(message.getAdvertise()));
        outBuffer.writeZero(4);
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private static int createPortConfigBitmask(PortConfig config) {
        int configBitmask = 0;
        HashMap<Integer, Boolean> portConfigMap = new HashMap<Integer, Boolean>();
        portConfigMap.put(0, config.isPortDown());
        portConfigMap.put(2, config.isNoRecv());
        portConfigMap.put(5, config.isNoFwd());
        portConfigMap.put(6, config.isNoPacketIn());
        configBitmask = ByteBufUtils.fillBitMaskFromMap(portConfigMap);
        return configBitmask;
    }

    private static int createPortFeaturesBitmask(PortFeatures feature) {
        return ByteBufUtils.fillBitMask((int)0, (boolean[])new boolean[]{feature.is_10mbHd(), feature.is_10mbFd(), feature.is_100mbHd(), feature.is_100mbFd(), feature.is_1gbHd(), feature.is_1gbFd(), feature.is_10gbFd(), feature.is_40gbFd(), feature.is_100gbFd(), feature.is_1tbFd(), feature.isOther(), feature.isCopper(), feature.isFiber(), feature.isAutoneg(), feature.isPause(), feature.isPauseAsym()});
    }
}

