/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;

public class PortStatusMessageFactory
implements OFSerializer<PortStatusMessage> {
    private static final byte MESSAGE_TYPE = 12;
    private static final byte PADDING = 7;
    private static final byte PORT_PADDING_1 = 4;
    private static final byte PORT_PADDING_2 = 2;

    public void serialize(PortStatusMessage message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)12, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeByte(message.getReason().getIntValue());
        outBuffer.writeZero(7);
        outBuffer.writeInt(message.getPortNo().intValue());
        outBuffer.writeZero(4);
        this.writeMacAddress(message.getHwAddr().getValue(), outBuffer);
        outBuffer.writeZero(2);
        this.writeName(message.getName(), outBuffer);
        this.writePortConfig(message.getConfig(), outBuffer);
        this.writePortState(message.getState(), outBuffer);
        this.writePortFeatures(message.getCurrentFeatures(), outBuffer);
        this.writePortFeatures(message.getAdvertisedFeatures(), outBuffer);
        this.writePortFeatures(message.getSupportedFeatures(), outBuffer);
        this.writePortFeatures(message.getPeerFeatures(), outBuffer);
        outBuffer.writeInt(message.getCurrSpeed().intValue());
        outBuffer.writeInt(message.getMaxSpeed().intValue());
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private void writePortConfig(PortConfig config, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, config.isPortDown());
        map.put(2, config.isNoRecv());
        map.put(5, config.isNoFwd());
        map.put(6, config.isNoPacketIn());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }

    private void writeMacAddress(String macAddress, ByteBuf outBuffer) {
        String[] macAddressParts = macAddress.split(":");
        byte[] macAddressBytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            Integer hex = Integer.parseInt(macAddressParts[i], 16);
            macAddressBytes[i] = hex.byteValue();
        }
        outBuffer.writeBytes(macAddressBytes);
    }

    private void writeName(String name, ByteBuf outBuffer) {
        byte[] nameBytes = name.getBytes();
        if (nameBytes.length < 16) {
            byte[] nameBytesPadding = new byte[16];
            int i = 0;
            byte[] arr$ = nameBytes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                byte b;
                nameBytesPadding[i] = b = arr$[i$];
                ++i;
            }
            while (i < 16) {
                nameBytesPadding[i] = 0;
                ++i;
            }
            outBuffer.writeBytes(nameBytesPadding);
        } else {
            outBuffer.writeBytes(nameBytes);
        }
    }

    private void writePortState(PortState state, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, state.isLinkDown());
        map.put(1, state.isBlocked());
        map.put(2, state.isLive());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }

    private void writePortFeatures(PortFeatures features, ByteBuf outBuffer) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(0, features.is_10mbHd());
        map.put(1, features.is_10mbFd());
        map.put(2, features.is_100mbHd());
        map.put(3, features.is_100mbFd());
        map.put(4, features.is_1gbHd());
        map.put(5, features.is_1gbFd());
        map.put(6, features.is_10gbFd());
        map.put(7, features.is_40gbFd());
        map.put(8, features.is_100gbFd());
        map.put(9, features.is_1tbFd());
        map.put(10, features.isOther());
        map.put(11, features.isCopper());
        map.put(12, features.isFiber());
        map.put(13, features.isAutoneg());
        map.put(14, features.isPause());
        map.put(15, features.isPauseAsym());
        int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
        outBuffer.writeInt(bitmap);
    }
}

