/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ExperimenterIdQueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.RateQueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;

public class QueueGetConfigReplyMessageFactory
implements OFSerializer<GetQueueConfigOutput> {
    private static final byte MESSAGE_TYPE = 23;
    private static final byte PADDING = 4;
    public static final int QUEUE_LENGTH_INDEX = 8;
    public static final int PROPERTY_LENGTH_INDEX = 2;
    private static final byte QUEUE_PADDING = 6;
    private static final byte PROPERTY_HEADER_PADDING = 4;
    private static final byte PROPERTY_RATE_PADDING = 6;
    private static final byte PROPERTY_EXPERIMENTER_PADDING = 4;

    public void serialize(GetQueueConfigOutput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)23, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeInt(message.getPort().getValue().intValue());
        outBuffer.writeZero(4);
        for (Queues queue : message.getQueues()) {
            ByteBuf queueBuff = UnpooledByteBufAllocator.DEFAULT.buffer();
            queueBuff.writeInt(queue.getQueueId().getValue().intValue());
            queueBuff.writeInt(queue.getPort().getValue().intValue());
            queueBuff.writeShort(0);
            queueBuff.writeZero(6);
            for (QueueProperty property : queue.getQueueProperty()) {
                ByteBuf propertyBuff = UnpooledByteBufAllocator.DEFAULT.buffer();
                propertyBuff.writeShort(property.getProperty().getIntValue());
                propertyBuff.writeShort(0);
                propertyBuff.writeZero(4);
                switch (property.getProperty()) {
                    case OFPQTMINRATE: {
                        this.serializeRateBody((RateQueueProperty)property.getAugmentation(RateQueueProperty.class), propertyBuff);
                        break;
                    }
                    case OFPQTMAXRATE: {
                        this.serializeRateBody((RateQueueProperty)property.getAugmentation(RateQueueProperty.class), propertyBuff);
                        break;
                    }
                    case OFPQTEXPERIMENTER: {
                        this.serializeExperimenterBody((ExperimenterIdQueueProperty)property.getAugmentation(ExperimenterIdQueueProperty.class), propertyBuff);
                        break;
                    }
                }
                propertyBuff.setShort(2, propertyBuff.readableBytes());
                queueBuff.writeBytes(propertyBuff);
            }
            queueBuff.setShort(8, queueBuff.readableBytes());
            outBuffer.writeBytes(queueBuff);
        }
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private void serializeRateBody(RateQueueProperty body, ByteBuf outBuffer) {
        outBuffer.writeShort(body.getRate().intValue());
        outBuffer.writeZero(6);
    }

    private void serializeExperimenterBody(ExperimenterIdQueueProperty body, ByteBuf outBuffer) {
        outBuffer.writeInt(body.getExperimenter().getValue().intValue());
        outBuffer.writeZero(4);
    }
}

