/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.FlowRemovedMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PacketInMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PortStatusMask;

public class SetAsyncInputMessageFactory
implements OFSerializer<SetAsyncInput> {
    private static final byte MESSAGE_TYPE = 28;

    public void serialize(SetAsyncInput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)28, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        SetAsyncInputMessageFactory.serializePacketInMask(message.getPacketInMask(), outBuffer);
        SetAsyncInputMessageFactory.serializePortStatusMask(message.getPortStatusMask(), outBuffer);
        SetAsyncInputMessageFactory.serializerFlowRemovedMask(message.getFlowRemovedMask(), outBuffer);
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private static void serializePacketInMask(List<PacketInMask> packetInMask, ByteBuf outBuffer) {
        if (packetInMask != null) {
            for (PacketInMask currentPacketMask : packetInMask) {
                List mask = currentPacketMask.getMask();
                if (mask == null) continue;
                HashMap<Integer, Boolean> packetInReasonMap = new HashMap<Integer, Boolean>();
                for (PacketInReason packetInReason : mask) {
                    if (PacketInReason.OFPRNOMATCH.equals((Object)packetInReason)) {
                        packetInReasonMap.put(PacketInReason.OFPRNOMATCH.getIntValue(), true);
                        continue;
                    }
                    if (PacketInReason.OFPRACTION.equals((Object)packetInReason)) {
                        packetInReasonMap.put(PacketInReason.OFPRACTION.getIntValue(), true);
                        continue;
                    }
                    if (!PacketInReason.OFPRINVALIDTTL.equals((Object)packetInReason)) continue;
                    packetInReasonMap.put(PacketInReason.OFPRINVALIDTTL.getIntValue(), true);
                }
                outBuffer.writeInt(ByteBufUtils.fillBitMaskFromMap(packetInReasonMap));
            }
        }
    }

    private static void serializePortStatusMask(List<PortStatusMask> portStatusMask, ByteBuf outBuffer) {
        if (portStatusMask != null) {
            for (PortStatusMask currentPortStatusMask : portStatusMask) {
                List mask = currentPortStatusMask.getMask();
                if (mask == null) continue;
                HashMap<Integer, Boolean> portStatusReasonMap = new HashMap<Integer, Boolean>();
                for (PortReason packetInReason : mask) {
                    if (PortReason.OFPPRADD.equals((Object)packetInReason)) {
                        portStatusReasonMap.put(PortReason.OFPPRADD.getIntValue(), true);
                        continue;
                    }
                    if (PortReason.OFPPRDELETE.equals((Object)packetInReason)) {
                        portStatusReasonMap.put(PortReason.OFPPRDELETE.getIntValue(), true);
                        continue;
                    }
                    if (!PortReason.OFPPRMODIFY.equals((Object)packetInReason)) continue;
                    portStatusReasonMap.put(PortReason.OFPPRMODIFY.getIntValue(), true);
                }
                outBuffer.writeInt(ByteBufUtils.fillBitMaskFromMap(portStatusReasonMap));
            }
        }
    }

    private static void serializerFlowRemovedMask(List<FlowRemovedMask> flowRemovedMask, ByteBuf outBuffer) {
        if (flowRemovedMask != null) {
            for (FlowRemovedMask currentFlowRemovedMask : flowRemovedMask) {
                List mask = currentFlowRemovedMask.getMask();
                if (mask == null) continue;
                HashMap<Integer, Boolean> flowRemovedReasonMap = new HashMap<Integer, Boolean>();
                for (FlowRemovedReason packetInReason : mask) {
                    if (FlowRemovedReason.OFPRRIDLETIMEOUT.equals((Object)packetInReason)) {
                        flowRemovedReasonMap.put(FlowRemovedReason.OFPRRIDLETIMEOUT.getIntValue(), true);
                        continue;
                    }
                    if (FlowRemovedReason.OFPRRHARDTIMEOUT.equals((Object)packetInReason)) {
                        flowRemovedReasonMap.put(FlowRemovedReason.OFPRRHARDTIMEOUT.getIntValue(), true);
                        continue;
                    }
                    if (FlowRemovedReason.OFPRRDELETE.equals((Object)packetInReason)) {
                        flowRemovedReasonMap.put(FlowRemovedReason.OFPRRDELETE.getIntValue(), true);
                        continue;
                    }
                    if (!FlowRemovedReason.OFPRRGROUPDELETE.equals((Object)packetInReason)) continue;
                    flowRemovedReasonMap.put(FlowRemovedReason.OFPRRGROUPDELETE.getIntValue(), true);
                }
                outBuffer.writeInt(ByteBufUtils.fillBitMaskFromMap(flowRemovedReasonMap));
            }
        }
    }
}

