/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableModInput;

public class TableModInputMessageFactory
implements OFSerializer<TableModInput> {
    private static final byte MESSAGE_TYPE = 17;
    private static final byte PADDING_IN_TABLE_MOD_MESSAGE = 3;

    public void serialize(TableModInput message, ByteBuf outBuffer) {
        ByteBufUtils.writeOFHeader((byte)17, (OfHeader)message, (ByteBuf)outBuffer, (int)0);
        outBuffer.writeByte((int)message.getTableId().getValue().byteValue());
        outBuffer.writeZero(3);
        outBuffer.writeInt(TableModInputMessageFactory.createConfigBitmask(message.getConfig()));
        ByteBufUtils.updateOFHeaderLength((ByteBuf)outBuffer);
    }

    private static int createConfigBitmask(TableConfig tableConfig) {
        return ByteBufUtils.fillBitMask((int)3, (boolean[])new boolean[]{tableConfig.isOFPTCDEPRECATEDMASK()});
    }
}

