/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.util.ExperimenterSerializerKeyFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterOfMessage;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class VendorInputMessageFactory
implements OFSerializer<ExperimenterOfMessage>,
SerializerRegistryInjector {
    private SerializerRegistry registry;

    public void serialize(ExperimenterOfMessage message, ByteBuf outBuffer) {
        long expId = message.getExperimenter().getValue();
        OFSerializer serializer = (OFSerializer)this.registry.getSerializer((MessageTypeKey)ExperimenterSerializerKeyFactory.createExperimenterMessageSerializerKey((short)1, (long)expId, (long)message.getExpType()));
        outBuffer.writeInt(message.getExperimenter().getValue().intValue());
        serializer.serialize((DataContainer)message.getExperimenterDataOfChoice(), outBuffer);
    }

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }
}

