/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.instruction;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.impl.serialization.instruction.AbstractInstructionSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.ListSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMakerFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;

public abstract class AbstractActionInstructionSerializer
extends AbstractInstructionSerializer
implements SerializerRegistryInjector {
    private static final TypeKeyMaker<Action> ACTION_KEY_MAKER = TypeKeyMakerFactory.createActionKeyMaker((short)4);
    private SerializerRegistry registry;

    protected void writeActions(List<Action> actions, ByteBuf outBuffer, int startIndex) {
        int lengthIndex = outBuffer.writerIndex();
        outBuffer.writeShort(0);
        outBuffer.writeZero(4);
        ListSerializer.serializeList(actions, ACTION_KEY_MAKER, this.getRegistry(), outBuffer);
        int instructionLength = outBuffer.writerIndex() - startIndex;
        outBuffer.setShort(lengthIndex, instructionLength);
    }

    protected SerializerRegistry getRegistry() {
        return this.registry;
    }

    public void injectSerializerRegistry(SerializerRegistry serializerRegistry) {
        this.registry = serializerRegistry;
    }
}

