/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import com.google.common.net.InetAddresses;
import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.AbstractOxmMatchEntrySerializer;

public abstract class AbstractOxmIpv6AddressSerializer
extends AbstractOxmMatchEntrySerializer {
    protected void writeIpv6Address(String textAddress, ByteBuf outBuffer) {
        if (!InetAddresses.isInetAddress((String)textAddress)) {
            throw new IllegalArgumentException("Invalid ipv6 address received: " + textAddress);
        }
        byte[] binaryAddress = InetAddresses.forString((String)textAddress).getAddress();
        outBuffer.writeBytes(binaryAddress);
    }
}

