/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.api.extensibility.HeaderSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;

public abstract class AbstractOxmMatchEntrySerializer
implements OFSerializer<MatchEntry>,
HeaderSerializer<MatchEntry> {
    public void serialize(MatchEntry entry, ByteBuf outBuffer) {
        this.serializeHeader(entry, outBuffer);
    }

    public void serializeHeader(MatchEntry entry, ByteBuf outBuffer) {
        outBuffer.writeShort(this.getOxmClassCode());
        AbstractOxmMatchEntrySerializer.writeOxmFieldAndLength(outBuffer, this.getOxmFieldCode(), entry.isHasMask(), this.getValueLength());
    }

    protected static void writeMask(byte[] mask, ByteBuf out, int length) {
        if (mask != null && mask.length != length) {
            throw new IllegalArgumentException("incorrect length of mask: " + mask.length + ", expected: " + length);
        }
        out.writeBytes(mask);
    }

    protected static void writeOxmFieldAndLength(ByteBuf out, int fieldValue, boolean hasMask, int lengthArg) {
        int fieldAndMask = fieldValue << 1;
        int length = lengthArg;
        if (hasMask) {
            fieldAndMask |= 1;
            length *= 2;
        }
        out.writeByte(fieldAndMask);
        out.writeByte(length);
    }

    protected abstract int getOxmFieldCode();

    protected abstract int getOxmClassCode();

    protected abstract int getValueLength();
}

