/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.AbstractOxmMacAddressSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpShaCase;

public class OxmArpShaSerializer
extends AbstractOxmMacAddressSerializer {
    @Override
    public void serialize(MatchEntry entry, ByteBuf outBuffer) {
        super.serialize(entry, outBuffer);
        ArpShaCase entryValue = (ArpShaCase)entry.getMatchEntryValue();
        this.writeMacAddress(entryValue.getArpSha().getMacAddress(), outBuffer);
        if (entry.isHasMask().booleanValue()) {
            OxmArpShaSerializer.writeMask(entryValue.getArpSha().getMask(), outBuffer, 6);
        }
    }

    @Override
    protected int getOxmClassCode() {
        return 32768;
    }

    @Override
    protected int getOxmFieldCode() {
        return 24;
    }

    @Override
    protected int getValueLength() {
        return 6;
    }
}

