/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.AbstractOxmIpv4AddressSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpSpaCase;

public class OxmArpSpaSerializer
extends AbstractOxmIpv4AddressSerializer {
    @Override
    public void serialize(MatchEntry entry, ByteBuf outBuffer) {
        super.serialize(entry, outBuffer);
        ArpSpaCase entryValue = (ArpSpaCase)entry.getMatchEntryValue();
        OxmArpSpaSerializer.writeIpv4Address(entryValue.getArpSpa().getIpv4Address().getValue(), outBuffer);
        if (entry.isHasMask().booleanValue()) {
            OxmArpSpaSerializer.writeMask(entryValue.getArpSpa().getMask(), outBuffer, 4);
        }
    }

    @Override
    protected int getOxmClassCode() {
        return 32768;
    }

    @Override
    protected int getOxmFieldCode() {
        return 22;
    }

    @Override
    protected int getValueLength() {
        return 4;
    }
}

