/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.AbstractOxmMacAddressSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.EthDstCase;

public class OxmEthDstSerializer
extends AbstractOxmMacAddressSerializer {
    @Override
    public void serialize(MatchEntry entry, ByteBuf outBuffer) {
        super.serialize(entry, outBuffer);
        EthDstCase entryValue = (EthDstCase)entry.getMatchEntryValue();
        this.writeMacAddress(entryValue.getEthDst().getMacAddress(), outBuffer);
        if (entry.isHasMask().booleanValue()) {
            OxmEthDstSerializer.writeMask(entryValue.getEthDst().getMask(), outBuffer, 6);
        }
    }

    @Override
    protected int getOxmClassCode() {
        return 32768;
    }

    @Override
    protected int getOxmFieldCode() {
        return 3;
    }

    @Override
    protected int getValueLength() {
        return 6;
    }
}

