/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.AbstractOxmMacAddressSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.EthSrcCase;

public class OxmEthSrcSerializer
extends AbstractOxmMacAddressSerializer {
    @Override
    public void serialize(MatchEntry entry, ByteBuf outBuffer) {
        super.serialize(entry, outBuffer);
        EthSrcCase entryValue = (EthSrcCase)entry.getMatchEntryValue();
        this.writeMacAddress(entryValue.getEthSrc().getMacAddress(), outBuffer);
        if (entry.isHasMask().booleanValue()) {
            OxmEthSrcSerializer.writeMask(entryValue.getEthSrc().getMask(), outBuffer, 6);
        }
    }

    @Override
    protected int getOxmClassCode() {
        return 32768;
    }

    @Override
    protected int getValueLength() {
        return 6;
    }

    @Override
    protected int getOxmFieldCode() {
        return 4;
    }
}

