/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.AbstractOxmIpv4AddressSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv4DstCase;

public class OxmIpv4DstSerializer
extends AbstractOxmIpv4AddressSerializer {
    @Override
    public void serialize(MatchEntry entry, ByteBuf outBuffer) {
        super.serialize(entry, outBuffer);
        Ipv4DstCase entryValue = (Ipv4DstCase)entry.getMatchEntryValue();
        OxmIpv4DstSerializer.writeIpv4Address(entryValue.getIpv4Dst().getIpv4Address().getValue(), outBuffer);
        if (entry.isHasMask().booleanValue()) {
            OxmIpv4DstSerializer.writeMask(entryValue.getIpv4Dst().getMask(), outBuffer, 4);
        }
    }

    @Override
    protected int getOxmClassCode() {
        return 32768;
    }

    @Override
    protected int getOxmFieldCode() {
        return 12;
    }

    @Override
    protected int getValueLength() {
        return 4;
    }
}

