/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.match.AbstractOxmIpv6AddressSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6DstCase;

public class OxmIpv6DstSerializer
extends AbstractOxmIpv6AddressSerializer {
    @Override
    public void serialize(MatchEntry entry, ByteBuf outBuffer) {
        super.serialize(entry, outBuffer);
        Ipv6DstCase entryValue = (Ipv6DstCase)entry.getMatchEntryValue();
        this.writeIpv6Address(entryValue.getIpv6Dst().getIpv6Address().getValue(), outBuffer);
        if (entry.isHasMask().booleanValue()) {
            OxmIpv6DstSerializer.writeMask(entryValue.getIpv6Dst().getMask(), outBuffer, 16);
        }
    }

    @Override
    protected int getOxmClassCode() {
        return 32768;
    }

    @Override
    protected int getOxmFieldCode() {
        return 27;
    }

    @Override
    protected int getValueLength() {
        return 16;
    }
}

